/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.WebElement;

public class Or
extends Condition {
    private final List<Condition> conditions;

    public Or(String name, List<Condition> conditions) {
        super(name);
        this.conditions = conditions;
    }

    @Override
    public boolean apply(Driver driver, WebElement element) {
        for (Condition c : this.conditions) {
            if (!c.apply(driver, element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String actualValue(Driver driver, WebElement element) {
        return this.conditions.stream().map(condition -> condition.actualValue(driver, element)).collect(Collectors.joining(", "));
    }

    @Override
    public String toString() {
        String conditionsToString = this.conditions.stream().map(Condition::toString).collect(Collectors.joining(" or "));
        return String.format("%s: %s", this.getName(), conditionsToString);
    }
}

