/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.ex;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ex.ErrorMessages;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.ScreenShotLaboratory;

public class UIAssertionError
extends AssertionError {
    private final Driver driver;
    private String screenshot;
    public long timeoutMs;

    protected UIAssertionError(Driver driver, String message) {
        super((Object)message);
        this.driver = driver;
    }

    protected UIAssertionError(Driver driver, String message, Throwable cause) {
        super(message, cause);
        this.driver = driver;
    }

    public final String getMessage() {
        return super.getMessage() + this.uiDetails();
    }

    public final String toString() {
        return this.getMessage();
    }

    protected String uiDetails() {
        return ErrorMessages.screenshot(this.driver.config(), this.screenshot) + ErrorMessages.timeout(this.timeoutMs) + ErrorMessages.causedBy(this.getCause());
    }

    public String getScreenshot() {
        return this.screenshot;
    }

    public static Error wrap(Driver driver, Error error, long timeoutMs) {
        if (Cleanup.of.isInvalidSelectorError(error)) {
            return error;
        }
        return UIAssertionError.wrapThrowable(driver, error, timeoutMs);
    }

    private static Error wrapThrowable(Driver driver, Throwable error, long timeoutMs) {
        UIAssertionError uiError = error instanceof UIAssertionError ? (UIAssertionError)((Object)error) : UIAssertionError.wrapToUIAssertionError(driver, error);
        uiError.timeoutMs = timeoutMs;
        uiError.screenshot = ScreenShotLaboratory.getInstance().formatScreenShotPath(driver);
        return uiError;
    }

    private static UIAssertionError wrapToUIAssertionError(Driver driver, Throwable error) {
        String message = error.getClass().getSimpleName() + ": " + Cleanup.of.webdriverExceptionMessage(error.getMessage());
        return new UIAssertionError(driver, message, error);
    }
}

