/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.proxy.DownloadedFile;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Set;

public class DownloadDetector
implements Comparator<DownloadedFile>,
Serializable {
    private static final Set<String> LOW_RANK_CONTENT_TYPES = ImmutableSet.of((Object)"text/html", (Object)"text/plain", (Object)"text/css", (Object)"text/javascript", (Object)"application/json");

    @Override
    public int compare(DownloadedFile file1, DownloadedFile file2) {
        boolean isHtmlOrCss2;
        boolean isHtmlOrCss1;
        int result = Boolean.compare(file2.hasContentDispositionHeader(), file1.hasContentDispositionHeader());
        if (result == 0 && (result = Boolean.compare(isHtmlOrCss1 = LOW_RANK_CONTENT_TYPES.contains(file1.getContentType()), isHtmlOrCss2 = LOW_RANK_CONTENT_TYPES.contains(file2.getContentType()))) == 0 && (result = Long.compare(file1.getFile().lastModified(), file2.getFile().lastModified())) == 0) {
            result = file1.getFile().getName().compareTo(file2.getFile().getName());
        }
        return result;
    }
}

