/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.junit;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Screenshots;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.ex.ErrorMessages;
import com.codeborne.selenide.ex.UIAssertionError;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenShooter
extends TestWatcher {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public boolean captureSuccessfulTests;

    private ScreenShooter() {
    }

    public static ScreenShooter failedTests() {
        return new ScreenShooter();
    }

    public ScreenShooter succeededTests() {
        this.captureSuccessfulTests = true;
        return this;
    }

    protected void starting(Description test) {
        Screenshots.startContext(test.getClassName(), test.getMethodName());
    }

    protected void succeeded(Description test) {
        if (this.captureSuccessfulTests) {
            this.log.info(ErrorMessages.screenshot(WebDriverRunner.driver()));
        }
    }

    protected void failed(Throwable e, Description description) {
        if (!(e instanceof UIAssertionError)) {
            this.log.info(ErrorMessages.screenshot(WebDriverRunner.driver()));
        }
    }

    protected void finished(Description description) {
        Screenshots.finishContext();
    }

    public ScreenShooter to(String folderWithScreenshots) {
        Configuration.reportsFolder = folderWithScreenshots;
        return this;
    }
}

