/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.collections;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.MatcherError;
import com.codeborne.selenide.impl.WebElementsCollection;
import java.util.List;
import java.util.function.Predicate;
import org.openqa.selenium.WebElement;

public class NoneMatch
extends CollectionCondition {
    private static final String MATCHER = "none";
    protected final String description;
    protected final Predicate<WebElement> predicate;

    public NoneMatch(String description, Predicate<WebElement> predicate) {
        this.description = description;
        this.predicate = predicate;
    }

    public boolean apply(List<WebElement> elements) {
        if (elements.isEmpty()) {
            return false;
        }
        return elements.stream().noneMatch(this.predicate);
    }

    @Override
    public void fail(WebElementsCollection collection, List<WebElement> elements, Exception lastError, long timeoutMs) {
        if (elements == null || elements.isEmpty()) {
            ElementNotFound elementNotFound = new ElementNotFound(collection, this.toString(), (Throwable)lastError);
            elementNotFound.timeoutMs = timeoutMs;
            throw elementNotFound;
        }
        throw new MatcherError(MATCHER, this.description, this.explanation, collection, elements, lastError, timeoutMs);
    }

    @Override
    public boolean applyNull() {
        return false;
    }

    public String toString() {
        return String.format("%s match [%s] predicate", MATCHER, this.description);
    }
}

