/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class HttpHelper {
    private final Pattern pattern = Pattern.compile(".*filename\\*?=\"?((.+)'')?([^\";?]*)\"?(;charset=(.*))?.*", 2);

    public Optional<String> getFileNameFromContentDisposition(Map<String, String> headers) {
        return this.getFileNameFromContentDisposition(headers.entrySet());
    }

    public Optional<String> getFileNameFromContentDisposition(Collection<Map.Entry<String, String>> headers) {
        for (Map.Entry<String, String> header : headers) {
            Optional<String> fileName = this.getFileNameFromContentDisposition(header.getKey(), header.getValue());
            if (!fileName.isPresent()) continue;
            return fileName;
        }
        return Optional.empty();
    }

    public Optional<String> getFileNameFromContentDisposition(String headerName, String headerValue) {
        if (!"Content-Disposition".equalsIgnoreCase(headerName) || headerValue == null) {
            return Optional.empty();
        }
        Matcher regex = this.pattern.matcher(headerValue);
        if (!regex.matches()) {
            return Optional.empty();
        }
        String fileName = regex.replaceFirst("$3");
        String encoding = (String)StringUtils.defaultIfEmpty((CharSequence)regex.replaceFirst("$2"), (CharSequence)regex.replaceFirst("$5"));
        return Optional.of(this.decodeHttpHeader(fileName, encoding));
    }

    private String decodeHttpHeader(String encoded, String encoding) {
        try {
            return URLDecoder.decode(encoded, (String)StringUtils.defaultIfEmpty((CharSequence)encoding, (CharSequence)"UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getFileName(String url) {
        return this.trimQuery(FilenameUtils.getName((String)url));
    }

    private String trimQuery(String filenameWithQuery) {
        return filenameWithQuery.contains("?") ? StringUtils.left((String)filenameWithQuery, (int)filenameWithQuery.indexOf("?")) : filenameWithQuery;
    }
}

