/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FirefoxDriverFactory
extends AbstractDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(FirefoxDriverFactory.class);

    FirefoxDriverFactory() {
    }

    @Override
    boolean supports(Config config, Browser browser) {
        return browser.isFirefox();
    }

    @Override
    WebDriver create(Config config, Proxy proxy) {
        String logFilePath = System.getProperty("webdriver.firefox.logfile", "/dev/null");
        System.setProperty("webdriver.firefox.logfile", logFilePath);
        return this.createFirefoxDriver(config, proxy);
    }

    private WebDriver createFirefoxDriver(Config config, Proxy proxy) {
        FirefoxOptions options = this.createFirefoxOptions(config, proxy);
        return new FirefoxDriver(options);
    }

    FirefoxOptions createFirefoxOptions(Config config, Proxy proxy) {
        FirefoxOptions firefoxOptions = new FirefoxOptions();
        firefoxOptions.setHeadless(config.headless());
        if (!config.browserBinary().isEmpty()) {
            log.info("Using browser binary: {}", (Object)config.browserBinary());
            firefoxOptions.setBinary(config.browserBinary());
        }
        firefoxOptions.addPreference("network.automatic-ntlm-auth.trusted-uris", "http://,https://");
        firefoxOptions.addPreference("network.automatic-ntlm-auth.allow-non-fqdn", true);
        firefoxOptions.addPreference("network.negotiate-auth.delegation-uris", "http://,https://");
        firefoxOptions.addPreference("network.negotiate-auth.trusted-uris", "http://,https://");
        firefoxOptions.addPreference("network.http.phishy-userpass-length", 255);
        firefoxOptions.addPreference("security.csp.enable", false);
        firefoxOptions.addPreference("network.proxy.no_proxies_on", "");
        firefoxOptions.addPreference("network.proxy.allow_hijacking_localhost", true);
        firefoxOptions.merge((Capabilities)this.createCommonCapabilities(config, proxy));
        FirefoxProfile profile = Optional.ofNullable(firefoxOptions.getProfile()).orElseGet(FirefoxProfile::new);
        this.setupDownloadsFolder(config, profile);
        this.transferFirefoxProfileFromSystemProperties(profile);
        firefoxOptions.setProfile(profile);
        return firefoxOptions;
    }

    private void setupDownloadsFolder(Config config, FirefoxProfile profile) {
        if (profile.getStringPreference("browser.download.dir", "").isEmpty()) {
            profile.setPreference("browser.download.dir", new File(config.downloadsFolder()).getAbsolutePath());
            profile.setPreference("browser.helperApps.neverAsk.saveToDisk", this.popularContentTypes());
            profile.setPreference("pdfjs.disabled", true);
            profile.setPreference("browser.download.folderList", 2);
        }
    }

    String popularContentTypes() {
        try {
            return String.join((CharSequence)";", IOUtils.readLines((InputStream)this.getClass().getResourceAsStream("/content-types.properties"), (Charset)StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            return "text/plain;text/csv;application/zip;application/pdf;application/octet-stream;application/msword;application/vnd.ms-excel;text/css;text/html";
        }
    }

    private void transferFirefoxProfileFromSystemProperties(FirefoxProfile profile) {
        String prefix = "firefoxprofile.";
        for (String key : System.getProperties().stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            String capability = key.substring(prefix.length());
            String value = System.getProperties().getProperty(key);
            log.debug("Use {}={}", (Object)key, (Object)value);
            if (this.isBoolean(value)) {
                profile.setPreference(capability, Boolean.parseBoolean(value));
                continue;
            }
            if (this.isInteger(value)) {
                profile.setPreference(capability, Integer.parseInt(value));
                continue;
            }
            profile.setPreference(capability, value);
        }
    }

    private boolean isBoolean(String value) {
        return "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value);
    }

    private boolean isInteger(String value) {
        return value.matches("^-?\\d+$");
    }
}

