/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.junit5;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Screenshots;
import com.codeborne.selenide.ex.UIAssertionError;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.reflect.Method;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenShooterExtension
implements BeforeEachCallback,
AfterTestExecutionCallback {
    private static final Logger log = LoggerFactory.getLogger(ScreenShooterExtension.class);
    private final boolean captureSuccessfulTests;

    public ScreenShooterExtension() {
        this(false);
    }

    public ScreenShooterExtension(boolean captureSuccessfulTests) {
        this.captureSuccessfulTests = captureSuccessfulTests;
    }

    @CanIgnoreReturnValue
    public ScreenShooterExtension to(String folderWithScreenshots) {
        Configuration.reportsFolder = folderWithScreenshots;
        return this;
    }

    public void beforeEach(ExtensionContext context) {
        Optional testClass = context.getTestClass();
        String className = testClass.map(Class::getName).orElse("EmptyClass");
        Optional testMethod = context.getTestMethod();
        String methodName = testMethod.map(Method::getName).orElse("emptyMethod");
        Screenshots.startContext(className, methodName);
    }

    public void afterTestExecution(ExtensionContext context) {
        if (this.captureSuccessfulTests) {
            log.info(Screenshots.saveScreenshotAndPageSource());
        } else {
            context.getExecutionException().ifPresent(error -> {
                if (!(error instanceof UIAssertionError)) {
                    log.info(Screenshots.saveScreenshotAndPageSource());
                }
            });
        }
        Screenshots.finishContext();
    }
}

