/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.DownloadsFolder;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ThreadLocalSelenideConfig;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebDriver;

@ParametersAreNonnullByDefault
class StaticDriver
implements Driver {
    private final Config config = new ThreadLocalSelenideConfig();

    StaticDriver() {
    }

    @CheckReturnValue
    @Nonnull
    public Config config() {
        return this.config;
    }

    @CheckReturnValue
    @Nonnull
    public Browser browser() {
        return new Browser(this.config.browser(), this.config.headless());
    }

    @CheckReturnValue
    public boolean hasWebDriverStarted() {
        return WebDriverRunner.hasWebDriverStarted();
    }

    @CheckReturnValue
    @Nonnull
    public WebDriver getWebDriver() {
        return WebDriverRunner.getWebDriver();
    }

    @CheckReturnValue
    @Nonnull
    public SelenideProxyServer getProxy() {
        return WebDriverRunner.getSelenideProxy();
    }

    @CheckReturnValue
    @Nonnull
    public WebDriver getAndCheckWebDriver() {
        return WebDriverRunner.getAndCheckWebDriver();
    }

    @CheckReturnValue
    @Nullable
    public DownloadsFolder browserDownloadsFolder() {
        return WebDriverRunner.getBrowserDownloadsFolder();
    }

    public void close() {
        WebDriverRunner.closeWebDriver();
    }
}

