/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.AssertionMode;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.FileDownloadMode;
import com.codeborne.selenide.SelectorMode;
import com.codeborne.selenide.StaticConfig;
import com.codeborne.selenide.TextCheck;
import org.openqa.selenium.MutableCapabilities;

final class ThreadLocalSelenideConfig
implements Config {
    private static final StaticConfig staticConfig = new StaticConfig();
    private static final ThreadLocal<Config> config = ThreadLocal.withInitial(() -> staticConfig);

    ThreadLocalSelenideConfig() {
    }

    void set(Config perThreadConfig) {
        config.set(perThreadConfig);
    }

    Config get() {
        return config.get();
    }

    void reset() {
        config.remove();
    }

    public String browser() {
        return config.get().browser();
    }

    public boolean headless() {
        return config.get().headless();
    }

    public String remote() {
        return config.get().remote();
    }

    public String browserSize() {
        return config.get().browserSize();
    }

    public String browserVersion() {
        return config.get().browserVersion();
    }

    public String browserPosition() {
        return config.get().browserPosition();
    }

    public boolean webdriverLogsEnabled() {
        return config.get().webdriverLogsEnabled();
    }

    public String browserBinary() {
        return config.get().browserBinary();
    }

    public String pageLoadStrategy() {
        return config.get().pageLoadStrategy();
    }

    public long pageLoadTimeout() {
        return config.get().pageLoadTimeout();
    }

    public MutableCapabilities browserCapabilities() {
        return config.get().browserCapabilities();
    }

    public String baseUrl() {
        return config.get().baseUrl();
    }

    public long timeout() {
        return config.get().timeout();
    }

    public long pollingInterval() {
        return config.get().pollingInterval();
    }

    public boolean holdBrowserOpen() {
        return config.get().holdBrowserOpen();
    }

    public boolean reopenBrowserOnFail() {
        return config.get().reopenBrowserOnFail();
    }

    public boolean clickViaJs() {
        return config.get().clickViaJs();
    }

    public boolean screenshots() {
        return config.get().screenshots();
    }

    public boolean savePageSource() {
        return config.get().savePageSource();
    }

    public String reportsFolder() {
        return config.get().reportsFolder();
    }

    public String downloadsFolder() {
        return config.get().downloadsFolder();
    }

    public String reportsUrl() {
        return config.get().reportsUrl();
    }

    public boolean fastSetValue() {
        return config.get().fastSetValue();
    }

    public TextCheck textCheck() {
        return config.get().textCheck();
    }

    public SelectorMode selectorMode() {
        return config.get().selectorMode();
    }

    public AssertionMode assertionMode() {
        return config.get().assertionMode();
    }

    public FileDownloadMode fileDownload() {
        return config.get().fileDownload();
    }

    public boolean proxyEnabled() {
        return config.get().proxyEnabled();
    }

    public String proxyHost() {
        return config.get().proxyHost();
    }

    public int proxyPort() {
        return config.get().proxyPort();
    }

    public long remoteReadTimeout() {
        return config.get().remoteReadTimeout();
    }

    public long remoteConnectionTimeout() {
        return config.get().remoteConnectionTimeout();
    }
}

