/*
 * Decompiled with CFR 0.152.
 */
package org.codeheadsystems.featureflag.manager;

import com.codeheadsystems.metrics.Metrics;
import com.codeheadsystems.metrics.Tags;
import java.util.Optional;
import org.codeheadsystems.featureflag.manager.FeatureLookupManager;
import org.codeheadsystems.featureflag.manager.FeatureManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsDecorator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsDecorator.class);
    private final Metrics metrics;

    public MetricsDecorator(Metrics metrics) {
        this.metrics = metrics;
        LOGGER.info("MetricsDecorator({})", (Object)metrics);
    }

    public FeatureManager.Decorator<FeatureManager> featureManagerDecorator() {
        return delegate -> {
            LOGGER.info("decorateFeatureManager({})", delegate);
            return new FeatureManager(){
                final /* synthetic */ FeatureManager val$delegate;
                {
                    this.val$delegate = featureManager;
                }

                public boolean isEnabled(String featureId, String discriminator) {
                    boolean isEnabled = this.val$delegate.isEnabled(featureId, discriminator);
                    Tags tags = Tags.of((String[])new String[]{"feature", featureId, "discriminator", discriminator, "enabled", Boolean.toString(isEnabled)});
                    MetricsDecorator.this.metrics.increment("feature_flag_isEnabled", tags);
                    return isEnabled;
                }

                public void invalidate(String featureId) {
                    MetricsDecorator.this.metrics.time("feature_flag_invalidate", Tags.of((String[])new String[]{"feature", featureId}), () -> {
                        this.val$delegate.invalidate(featureId);
                        return null;
                    });
                }
            };
        };
    }

    public FeatureManager.Decorator<FeatureLookupManager> featureLookupManagerDecorator() {
        return delegate -> {
            LOGGER.info("decorateFeatureLookupManager({})", delegate);
            return new FeatureLookupManager(){
                final /* synthetic */ FeatureLookupManager val$delegate;
                {
                    this.val$delegate = featureLookupManager;
                }

                public Optional<Double> lookupPercentage(String featureId) {
                    return (Optional)MetricsDecorator.this.metrics.time("feature_flag_lookup", Tags.of((String[])new String[]{"feature", featureId}), () -> this.val$delegate.lookupPercentage(featureId));
                }

                public boolean setPercentage(String featureId, double percentage) {
                    return (Boolean)MetricsDecorator.this.metrics.time("feature_flag_setPercentage", Tags.of((String[])new String[]{"feature", featureId}), () -> this.val$delegate.setPercentage(featureId, percentage));
                }

                public void deletePercentage(String featureId) {
                    MetricsDecorator.this.metrics.time("feature_flag_deletePercentage", Tags.of((String[])new String[]{"feature", featureId}), () -> {
                        this.val$delegate.deletePercentage(featureId);
                        return null;
                    });
                }
            };
        };
    }
}

