/*
 * Decompiled with CFR 0.152.
 */
package org.codeheadsystems.featureflag.factory;

import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.apache.commons.codec.digest.MurmurHash3;
import org.codeheadsystems.featureflag.factory.Enablement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnablementFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnablementFactory.class);
    private final Function<String, Integer> hashFunction;

    public EnablementFactory() {
        this(EnablementFactory::defaultHash);
    }

    public EnablementFactory(Function<String, Integer> hashFunction) {
        this.hashFunction = hashFunction;
        LOGGER.info("EnablementFactory({})", hashFunction);
    }

    private static int defaultHash(String discriminator) {
        byte[] bytes = discriminator.getBytes(StandardCharsets.UTF_8);
        return MurmurHash3.hash32x86((byte[])bytes);
    }

    public Enablement generate(double percentage) {
        LOGGER.trace("generate({})", (Object)percentage);
        if (percentage <= 0.0) {
            LOGGER.trace("Disabled feature");
            return this.disabledFeature();
        }
        if (percentage >= 1.0) {
            LOGGER.trace("Enabled feature");
            return this.enabledFeature();
        }
        LOGGER.trace("Calculated feature");
        return this.percentageFeature(percentage);
    }

    public Enablement enabledFeature() {
        LOGGER.info("enabledFeature()");
        return discriminator -> true;
    }

    public Enablement disabledFeature() {
        LOGGER.info("disabledFeature()");
        return discriminator -> false;
    }

    public Enablement percentageFeature(double percentage) {
        LOGGER.info("percentageFeature({})", (Object)percentage);
        return discriminator -> {
            int hash = this.hashFunction.apply(discriminator);
            double calculated = (double)(hash % 100) / 100.0;
            LOGGER.trace("percentageFeature({}:{}) -> {} {}", new Object[]{discriminator, percentage, calculated, calculated < percentage});
            return calculated <= percentage;
        };
    }
}

