/*
 * Decompiled with CFR 0.152.
 */
package org.codeheadsystems.featureflag.manager;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.codeheadsystems.featureflag.factory.Enablement;
import org.codeheadsystems.featureflag.factory.EnablementFactory;
import org.codeheadsystems.featureflag.manager.FeatureLookupManager;
import org.codeheadsystems.featureflag.manager.impl.FeatureManagerImpl;
import org.codeheadsystems.featureflag.model.FeatureManagerConfiguration;
import org.codeheadsystems.featureflag.model.ImmutableFeatureManagerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface FeatureManager {
    public boolean isEnabled(String var1, String var2);

    default public <T> T ifEnabledElse(String featureId, String discriminator, Supplier<T> ifEnabled, Supplier<T> ifDisabled) {
        return this.isEnabled(featureId, discriminator) ? ifEnabled.get() : ifDisabled.get();
    }

    public void invalidate(String var1);

    public static class Builder {
        private static final Logger LOGGER = LoggerFactory.getLogger(FeatureManager.class);
        private EnablementFactory enablementFactory;
        private FeatureLookupManager featureLookupManager;
        private FeatureManagerConfiguration configuration;
        private Caffeine<String, Enablement> cacheBuilder;
        private List<Decorator<FeatureManager>> featureManagerDecorator = new ArrayList<Decorator<FeatureManager>>();
        private List<Decorator<FeatureLookupManager>> featureLookupManagerDecorator = new ArrayList<Decorator<FeatureLookupManager>>();

        private static Caffeine<String, Enablement> getDefaultCacheBuilder() {
            return Caffeine.newBuilder().maximumSize(100L).refreshAfterWrite(Duration.ofSeconds(60L)).expireAfterAccess(Duration.ofSeconds(600L)).removalListener((key, value, cause) -> LOGGER.trace("removalListener({})", key));
        }

        public Builder withFeatureManagerDecorator(Decorator<FeatureManager> decorator) {
            this.featureManagerDecorator.add(decorator);
            return this;
        }

        public Builder withFeatureLookupManagerDecorator(Decorator<FeatureLookupManager> decorator) {
            this.featureLookupManagerDecorator.add(decorator);
            return this;
        }

        public Builder withEnablementFactory(EnablementFactory enablementFactory) {
            this.enablementFactory = enablementFactory;
            return this;
        }

        public Builder withFeatureLookupManager(FeatureLookupManager featureLookupManager) {
            this.featureLookupManager = featureLookupManager;
            return this;
        }

        public Builder withConfiguration(FeatureManagerConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder withCacheBuilder(Caffeine<String, Enablement> cacheBuilder) {
            this.cacheBuilder = cacheBuilder;
            return this;
        }

        public FeatureManager build() {
            FeatureLookupManager internalLookupManager = Objects.requireNonNull(this.featureLookupManager, "Missing required fields: featureLookupManager");
            this.enablementFactory = Objects.requireNonNullElse(this.enablementFactory, new EnablementFactory());
            this.configuration = Objects.requireNonNullElse(this.configuration, ImmutableFeatureManagerConfiguration.builder().build());
            this.cacheBuilder = Objects.requireNonNullElse(this.cacheBuilder, Builder.getDefaultCacheBuilder());
            for (Decorator<FeatureLookupManager> decorator : this.featureLookupManagerDecorator) {
                LOGGER.info("Decorating featureLookupManager with {}", decorator);
                internalLookupManager = decorator.decorate(internalLookupManager);
            }
            FeatureManager featureManager = new FeatureManagerImpl(this);
            for (Decorator<FeatureManager> decorator : this.featureManagerDecorator) {
                LOGGER.info("Decorating featureManager with {}", decorator);
                featureManager = decorator.decorate(featureManager);
            }
            return featureManager;
        }

        public EnablementFactory getEnablementFactory() {
            return this.enablementFactory;
        }

        public FeatureLookupManager getFeatureLookupManager() {
            return this.featureLookupManager;
        }

        public FeatureManagerConfiguration getConfiguration() {
            return this.configuration;
        }

        public Caffeine<String, Enablement> getCacheBuilder() {
            return this.cacheBuilder;
        }
    }

    public static interface Decorator<T> {
        public T decorate(T var1);
    }
}

