/*
 * Decompiled with CFR 0.152.
 */
package org.codeheadsystems.featureflag.manager.impl;

import com.github.benmanes.caffeine.cache.LoadingCache;
import org.codeheadsystems.featureflag.factory.Enablement;
import org.codeheadsystems.featureflag.factory.EnablementFactory;
import org.codeheadsystems.featureflag.manager.FeatureLookupManager;
import org.codeheadsystems.featureflag.manager.FeatureManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureManagerImpl
implements FeatureManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureManagerImpl.class);
    private final EnablementFactory enablementFactory;
    private final FeatureLookupManager featureLookupManager;
    private final LoadingCache<String, Enablement> featureEnablementCache;

    public FeatureManagerImpl(FeatureManager.Builder builder) {
        this.enablementFactory = builder.getEnablementFactory();
        this.featureLookupManager = builder.getFeatureLookupManager();
        this.featureEnablementCache = builder.getCacheBuilder().executor(builder.getConfiguration().cacheLoaderExecutor()).build(this::lookup);
        LOGGER.info("FeatureManager({},{},{})", new Object[]{builder.getConfiguration(), this.featureLookupManager, this.enablementFactory});
    }

    private Enablement lookup(String featureId) {
        LOGGER.info("lookup({})", (Object)featureId);
        return this.featureLookupManager.lookupPercentage(featureId).map(this.enablementFactory::generate).orElseGet(this.enablementFactory::disabledFeature);
    }

    @Override
    public boolean isEnabled(String featureId, String discriminator) {
        try {
            return ((Enablement)this.featureEnablementCache.get((Object)featureId)).enabled(discriminator);
        }
        catch (RuntimeException e) {
            LOGGER.error("Error getting feature enablement for: {}:{}", new Object[]{featureId, discriminator, e});
            return false;
        }
    }

    @Override
    public void invalidate(String featureId) {
        this.featureEnablementCache.invalidate((Object)featureId);
    }
}

