/*
 * Decompiled with CFR 0.152.
 */
package com.codeheadsystems.metrics.impl;

import com.codahale.metrics.MetricRegistry;
import com.codeheadsystems.metrics.Tags;
import com.codeheadsystems.metrics.impl.MetricPublisher;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.dropwizard.DropwizardConfig;
import io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicrometerMetricsPublisher
implements MetricPublisher {
    private static final Logger log = LoggerFactory.getLogger(MicrometerMetricsPublisher.class);
    private final MeterRegistry meterRegistry;

    public MicrometerMetricsPublisher(MeterRegistry meterRegistry) {
        log.info("MicrometerMetricsPublisher({})", (Object)meterRegistry);
        this.meterRegistry = meterRegistry;
    }

    public MicrometerMetricsPublisher(MetricRegistry metricRegistry, final String prefix) {
        log.info("MicrometerMetricsPublisher({}, {}, {})", (Object)metricRegistry, (Object)prefix);
        DropwizardConfig config = new DropwizardConfig(){

            public String prefix() {
                return prefix;
            }

            public String get(String key) {
                return null;
            }
        };
        this.meterRegistry = new DropwizardMeterRegistry(config, metricRegistry, HierarchicalNameMapper.DEFAULT, Clock.SYSTEM){

            protected Double nullGaugeValue() {
                return null;
            }
        };
    }

    public void increment(String metricName, long value, Tags tags) {
        log.trace("increment({}, {}, {})", new Object[]{metricName, value, tags});
        this.meterRegistry.counter(metricName, (Iterable)this.convert(tags)).increment((double)value);
    }

    public void time(String metricName, Duration duration, Tags tags) {
        log.trace("time({}, {}, {})", new Object[]{metricName, duration, tags});
        this.meterRegistry.timer(metricName, (Iterable)this.convert(tags)).record(duration);
    }

    private io.micrometer.core.instrument.Tags convert(Tags tags) {
        List list = tags.getTags().entrySet().stream().map(entry -> Tag.of((String)((String)entry.getKey()), (String)((String)entry.getValue()))).collect(Collectors.toList());
        return io.micrometer.core.instrument.Tags.of(list);
    }
}

