/*
 * Decompiled with CFR 0.152.
 */
package com.codeheadsystems.metrics;

import com.codeheadsystems.metrics.CheckedSupplier;
import com.codeheadsystems.metrics.Metrics;
import com.codeheadsystems.metrics.Tags;
import com.codeheadsystems.metrics.TagsGenerator;
import com.codeheadsystems.metrics.helper.TagsGeneratorRegistry;
import com.codeheadsystems.metrics.impl.MetricPublisher;
import com.codeheadsystems.metrics.impl.MetricsImpl;
import com.codeheadsystems.metrics.impl.NullMetricsImpl;
import com.codeheadsystems.metrics.impl.NullMetricsPublisher;
import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricFactory
implements Metrics {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricFactory.class);
    private static final NullMetricsImpl NULL_METRICS = new NullMetricsImpl();
    private final Clock clock;
    private final MetricPublisher metricPublisher;
    private final Tags initialTags;
    private final TagsGenerator<Throwable> defaultTagsGeneratorForThrowable;
    private final TagsGeneratorRegistry tagsGeneratorRegistry;
    private final Boolean closeAndOpenOnlyForInitial;
    private final ThreadLocal<MetricsImpl> metricsImplThreadLocal;
    private final Function<String, String> metricsName;

    private MetricFactory(Builder builder) {
        this.clock = builder.clock;
        this.metricPublisher = builder.metricPublisher;
        this.initialTags = builder.tags;
        this.defaultTagsGeneratorForThrowable = builder.defaultTagsGeneratorForThrowable;
        this.tagsGeneratorRegistry = builder.tagsGeneratorRegistry;
        this.closeAndOpenOnlyForInitial = builder.closeAndOpenOnlyForInitial;
        this.metricsImplThreadLocal = new ThreadLocal();
        this.metricsName = builder.prefix == null ? Function.identity() : s -> builder.prefix + s;
        LOGGER.info("MetricFactory({},{},{},{},{})", new Object[]{this.clock, this.metricPublisher, this.initialTags, this.defaultTagsGeneratorForThrowable, this.tagsGeneratorRegistry});
    }

    public static Builder builder() {
        return Builder.builder();
    }

    public Metrics metrics() {
        MetricsImpl metrics = this.metricsImplThreadLocal.get();
        if (metrics == null) {
            LOGGER.info("No metrics found, returning a null metrics");
            return NULL_METRICS;
        }
        return metrics;
    }

    private MetricsImpl createMetrics(Tags tags) {
        return new MetricsImpl(this.clock, this.metricPublisher, this.defaultTagsGeneratorForThrowable, this.tagsGeneratorRegistry, tags, this.metricsName);
    }

    public MetricsContext enableMetricsContext() {
        MetricsImpl oldMetrics = this.metricsImplThreadLocal.get();
        Tags oldTags = oldMetrics == null ? this.initialTags : oldMetrics.getTags();
        MetricsImpl metrics = this.createMetrics(Tags.of(oldTags));
        this.metricsImplThreadLocal.set(metrics);
        if (!this.closeAndOpenOnlyForInitial.booleanValue() || oldMetrics == null) {
            metrics.open();
        }
        return new MetricsContext(oldMetrics, metrics);
    }

    public void disableMetricsContext(MetricsContext metricsContext) {
        if (!this.closeAndOpenOnlyForInitial.booleanValue() || metricsContext.oldMetrics == null) {
            metricsContext.currentMetrics.close();
        }
        if (metricsContext.oldMetrics == null) {
            this.metricsImplThreadLocal.remove();
        } else {
            this.metricsImplThreadLocal.set(metricsContext.oldMetrics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R with(Function<Metrics, R> function) {
        MetricsContext metricsContext = this.enableMetricsContext();
        try {
            R r = function.apply(metricsContext.currentMetrics);
            return r;
        }
        finally {
            this.disableMetricsContext(metricsContext);
        }
    }

    @Override
    public void increment(String metricName, long value, Tags tags) {
        if (this.metricsImplThreadLocal.get() != null) {
            this.metrics().increment(metricName, value, tags);
        } else {
            this.with(metrics -> {
                metrics.increment(metricName, value, tags);
                return null;
            });
        }
    }

    @Override
    public Tags and(Tags overrideTags) {
        if (this.metricsImplThreadLocal.get() != null) {
            return this.metrics().and(overrideTags);
        }
        return Tags.empty();
    }

    @Override
    public Tags and(String ... overrideTags) {
        if (this.metricsImplThreadLocal.get() != null) {
            return this.metrics().and(overrideTags);
        }
        return Tags.empty();
    }

    @Override
    public <R, E extends Exception> R time(String metricName, CheckedSupplier<R, E> supplier, TagsGenerator<R> tagsGeneratorForResult, TagsGenerator<Throwable> tagsGeneratorForThrowable, Tags tags) throws E {
        if (this.metricsImplThreadLocal.get() != null) {
            return this.metrics().time(metricName, supplier, tagsGeneratorForResult, tagsGeneratorForThrowable, tags);
        }
        AtomicReference atomicReference = new AtomicReference();
        Object r = this.with(metrics -> {
            try {
                return metrics.time(metricName, supplier, tagsGeneratorForResult, tagsGeneratorForThrowable, tags);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                atomicReference.set(e);
                return null;
            }
        });
        if (atomicReference.get() != null) {
            throw (Exception)atomicReference.get();
        }
        return (R)r;
    }

    @Override
    public void publishTime(String metricName, Duration duration, Tags tags) {
        this.metrics().publishTime(metricName, duration, tags);
    }

    public static class Builder {
        private static final Logger LOGGER = LoggerFactory.getLogger(Builder.class);
        private final Tags tags = Tags.empty();
        private Clock clock = Clock.systemUTC();
        private MetricPublisher metricPublisher = new NullMetricsPublisher();
        private TagsGenerator<Throwable> defaultTagsGeneratorForThrowable;
        private TagsGeneratorRegistry tagsGeneratorRegistry = new TagsGeneratorRegistry();
        private Boolean closeAndOpenOnlyForInitial = true;
        private String prefix = null;

        private Builder() {
        }

        public static Builder builder() {
            LOGGER.info("MetricFactory.Builder()");
            return new Builder();
        }

        public Builder withPrefix(String prefix) {
            LOGGER.info("withPrefix({})", (Object)prefix);
            this.prefix = prefix;
            return this;
        }

        public Builder withCloseAndOpenOnlyForInitial(Boolean closeAndOpenOnlyForInitial) {
            LOGGER.info("withCloseAndOpenOnlyForInitial({})", (Object)closeAndOpenOnlyForInitial);
            this.closeAndOpenOnlyForInitial = closeAndOpenOnlyForInitial;
            return this;
        }

        public Builder withClock(Clock clock) {
            LOGGER.info("withClock({})", (Object)clock);
            this.clock = clock;
            return this;
        }

        public Builder withMetricPublisher(MetricPublisher metricPublisher) {
            LOGGER.info("withMetricPublisher({})", (Object)metricPublisher);
            this.metricPublisher = metricPublisher;
            return this;
        }

        public Builder withTags(Tags tags) {
            LOGGER.info("withTags({})", (Object)tags);
            this.tags.add(tags);
            return this;
        }

        public Builder withTags(String ... tags) {
            LOGGER.info("withTags({})", (Object)tags);
            this.tags.add(tags);
            return this;
        }

        public Builder withDefaultTagsGeneratorForThrowable(TagsGenerator<Throwable> defaultTagsGeneratorForThrowable) {
            LOGGER.info("withDefaultTagsGeneratorForThrowable({})", defaultTagsGeneratorForThrowable);
            this.defaultTagsGeneratorForThrowable = defaultTagsGeneratorForThrowable;
            return this;
        }

        public Builder withTagsGeneratorRegistry(TagsGeneratorRegistry tagsGeneratorRegistry) {
            LOGGER.info("withTagsGeneratorRegistry({})", (Object)tagsGeneratorRegistry);
            this.tagsGeneratorRegistry = tagsGeneratorRegistry;
            return this;
        }

        public <R> Builder withTagsGenerator(Class<R> clazz, TagsGenerator<R> tagsGenerator) {
            LOGGER.info("withTagsGenerator({},{})", clazz, tagsGenerator);
            this.tagsGeneratorRegistry.register(clazz, tagsGenerator);
            return this;
        }

        public MetricFactory build() {
            LOGGER.info("build()");
            return new MetricFactory(this);
        }
    }

    public static class MetricsContext {
        private final MetricsImpl oldMetrics;
        private final MetricsImpl currentMetrics;
        private final long start;

        public MetricsContext(MetricsImpl oldMetrics, MetricsImpl currentMetrics) {
            this.oldMetrics = oldMetrics;
            this.currentMetrics = currentMetrics;
            this.start = currentMetrics.clock().millis();
        }

        public Duration duration() {
            return Duration.ofMillis(this.currentMetrics.clock().millis() - this.start);
        }
    }
}

