/*
 * Decompiled with CFR 0.152.
 */
package com.codeheadsystems.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Tags {
    private final Map<String, String> tags;

    public Tags(String ... tags) {
        this.tags = new HashMap<String, String>();
        this.add(tags);
    }

    public Tags(Map<String, String> tags) {
        this.tags = new HashMap<String, String>(tags);
    }

    public Tags(Tags tags) {
        this.tags = new HashMap<String, String>(tags.getTags());
    }

    public static Tags of(String ... tags) {
        return new Tags(tags);
    }

    public static Tags of(Tags tags) {
        return new Tags(tags);
    }

    public static Tags empty() {
        return new Tags(new String[0]);
    }

    public Tags add(String ... tags) {
        if (tags.length % 2 != 0) {
            throw new IllegalArgumentException("Tags must be in key value pairs");
        }
        for (int i = 0; i < tags.length; i += 2) {
            this.tags.put(tags[i], tags[i + 1]);
        }
        return this;
    }

    public Tags add(Tags tags) {
        this.tags.putAll(tags.getTags());
        return this;
    }

    public Tags from(String ... tags) {
        return new Tags(this).add(tags);
    }

    public Tags from(Tags tags) {
        return new Tags(this).add(tags);
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tags tags1 = (Tags)o;
        return Objects.equals(this.tags, tags1.tags);
    }

    public int hashCode() {
        return Objects.hashCode(this.tags);
    }

    public String toString() {
        return "Tags{tags=" + String.valueOf(this.tags) + "}";
    }
}

