/*
 * Decompiled with CFR 0.152.
 */
package com.codeheadsystems.metrics.helper;

import com.codeheadsystems.metrics.Tags;
import com.codeheadsystems.metrics.TagsGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TagsGeneratorRegistry {
    private final Map<Class<?>, TagsGenerator<?>> tagsGeneratorMap = new HashMap();

    public <R> void register(Class<R> clazz, TagsGenerator<R> tagsGenerator) {
        this.tagsGeneratorMap.put(clazz, tagsGenerator);
    }

    public <R> void deregister(Class<R> clazz) {
        this.tagsGeneratorMap.remove(clazz);
    }

    public <R> TagsGenerator<R> get(Class<R> clazz) {
        return this.tagsGeneratorMap.get(clazz);
    }

    public <R> void aggregateIfFound(Tags existingTags, R object) {
        if (object == null) {
            return;
        }
        Class<?> clazz = object.getClass();
        if (this.tagsGeneratorMap.containsKey(clazz)) {
            TagsGenerator<?> tagsGenerator = this.get(clazz);
            existingTags.add(tagsGenerator.from(object));
        }
    }

    public Set<Class<?>> getRegisteredClasses() {
        return this.tagsGeneratorMap.keySet();
    }
}

