/*
 * Decompiled with CFR 0.152.
 */
package com.codeheadsystems.metrics.impl;

import com.codeheadsystems.metrics.CheckedSupplier;
import com.codeheadsystems.metrics.Metrics;
import com.codeheadsystems.metrics.Tags;
import com.codeheadsystems.metrics.TagsGenerator;
import com.codeheadsystems.metrics.helper.TagsGeneratorRegistry;
import com.codeheadsystems.metrics.impl.MetricPublisher;
import java.time.Clock;
import java.time.Duration;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsImpl
implements AutoCloseable,
Metrics {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsImpl.class);
    private final Clock clock;
    private final MetricPublisher metricPublisher;
    private final TagsGenerator<Throwable> defaultTagsGeneratorForThrowable;
    private final TagsGeneratorRegistry tagsGeneratorRegistry;
    private final Tags tags;
    private final Function<String, String> name;

    public MetricsImpl(Clock clock, MetricPublisher metricPublisher, TagsGenerator<Throwable> defaultTagsGeneratorForThrowable, TagsGeneratorRegistry tagsGeneratorRegistry, Tags tags, Function<String, String> name) {
        LOGGER.info("MetricsImpl({},{})", (Object)metricPublisher, (Object)tags);
        this.clock = clock;
        this.tagsGeneratorRegistry = tagsGeneratorRegistry;
        this.metricPublisher = metricPublisher;
        this.tags = tags;
        this.defaultTagsGeneratorForThrowable = defaultTagsGeneratorForThrowable;
        this.name = name;
    }

    public void open() {
        try {
            this.metricPublisher.open();
        }
        catch (Throwable e) {
            LOGGER.warn("Metrics was unable to close", e);
        }
    }

    @Override
    public void close() {
        try {
            this.metricPublisher.close();
        }
        catch (Throwable e) {
            LOGGER.warn("Metrics was unable to close", e);
        }
    }

    public Clock clock() {
        return this.clock;
    }

    public Tags getTags() {
        return this.tags;
    }

    @Override
    public Tags and(Tags overrideTags) {
        this.getTags().add(overrideTags);
        return this.tags;
    }

    @Override
    public Tags and(String ... overrideTags) {
        this.getTags().add(overrideTags);
        return this.tags;
    }

    @Override
    public void increment(String metricName, long value, Tags tags) {
        Tags aggregateTags = this.getTags().from(tags);
        this.metricPublisher.increment(this.name.apply(metricName), value, aggregateTags);
    }

    @Override
    public <R, E extends Exception> R time(String metricName, CheckedSupplier<R, E> supplier, TagsGenerator<R> tagsGeneratorForResult, TagsGenerator<Throwable> tagsGeneratorForThrowable, Tags tags) throws E {
        Tags executedTags = Tags.empty();
        long start = this.clock.millis();
        long endDuration = 0L;
        try {
            R r = supplier.get();
            endDuration = this.clock.millis();
            if (tagsGeneratorForResult != null) {
                executedTags.add(tagsGeneratorForResult.from(r));
            } else if (this.tagsGeneratorRegistry != null) {
                this.tagsGeneratorRegistry.aggregateIfFound(executedTags, r);
            }
            R r2 = r;
            return r2;
        }
        catch (Throwable e) {
            endDuration = this.clock.millis();
            if (tagsGeneratorForThrowable != null) {
                executedTags.add(tagsGeneratorForThrowable.from(e));
            } else if (this.defaultTagsGeneratorForThrowable != null) {
                executedTags.add(this.defaultTagsGeneratorForThrowable.from(e));
            }
            throw e;
        }
        finally {
            long duration = endDuration - start;
            Tags finalTags = this.getTags().from(tags).add(executedTags);
            this.metricPublisher.time(this.name.apply(metricName), Duration.ofMillis(duration), finalTags);
        }
    }

    @Override
    public void publishTime(String metricName, Duration duration, Tags tags) {
        this.metricPublisher.time(this.name.apply(metricName), duration, tags);
    }
}

