/*
 * Decompiled with CFR 0.152.
 */
package org.cef;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.OS;
import org.cef.SystemBootstrap;
import org.cef.callback.CefSchemeHandlerFactory;
import org.cef.handler.CefAppHandler;
import org.cef.handler.CefAppHandlerAdapter;

public class CefApp
extends CefAppHandlerAdapter {
    private static CefApp self = null;
    private static CefAppHandler appHandler_ = null;
    private static CefAppState state_ = CefAppState.NONE;
    private Timer workTimer_ = null;
    private HashSet<CefClient> clients_ = new HashSet();
    private CefSettings settings_ = null;

    private CefApp(String[] stringArray, CefSettings cefSettings) throws UnsatisfiedLinkError {
        super(stringArray);
        if (cefSettings != null) {
            this.settings_ = cefSettings.clone();
        }
        if (OS.isWindows()) {
            SystemBootstrap.loadLibrary("jawt");
            SystemBootstrap.loadLibrary("chrome_elf");
            SystemBootstrap.loadLibrary("libcef");
            SystemBootstrap.loadLibrary("jcef");
        } else if (OS.isLinux()) {
            SystemBootstrap.loadLibrary("cef");
        }
        if (appHandler_ == null) {
            appHandler_ = this;
        }
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (!CefApp.this.N_PreInitialize()) {
                        throw new IllegalStateException("Failed to pre-initialize native code");
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void addAppHandler(CefAppHandler cefAppHandler) throws IllegalStateException {
        if (CefApp.getState().compareTo(CefAppState.NEW) > 0) {
            throw new IllegalStateException("Must be called before CefApp is initialized");
        }
        appHandler_ = cefAppHandler;
    }

    public static synchronized CefApp getInstance() throws UnsatisfiedLinkError {
        return CefApp.getInstance(null, null);
    }

    public static synchronized CefApp getInstance(String[] stringArray) throws UnsatisfiedLinkError {
        return CefApp.getInstance(stringArray, null);
    }

    public static synchronized CefApp getInstance(CefSettings cefSettings) throws UnsatisfiedLinkError {
        return CefApp.getInstance(null, cefSettings);
    }

    public static synchronized CefApp getInstance(String[] stringArray, CefSettings cefSettings) throws UnsatisfiedLinkError {
        if (cefSettings != null && CefApp.getState() != CefAppState.NONE && CefApp.getState() != CefAppState.NEW) {
            throw new IllegalStateException("Settings can only be passed to CEF before createClient is called the first time.");
        }
        if (self == null) {
            if (CefApp.getState() == CefAppState.TERMINATED) {
                throw new IllegalStateException("CefApp was terminated");
            }
            self = new CefApp(stringArray, cefSettings);
            CefApp.setState(CefAppState.NEW);
        }
        return self;
    }

    public final void setSettings(CefSettings cefSettings) throws IllegalStateException {
        if (CefApp.getState() != CefAppState.NONE && CefApp.getState() != CefAppState.NEW) {
            throw new IllegalStateException("Settings can only be passed to CEF before createClient is called the first time.");
        }
        this.settings_ = cefSettings.clone();
    }

    public final CefVersion getVersion() {
        try {
            return this.N_GetVersion();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final CefAppState getState() {
        CefAppState cefAppState = state_;
        synchronized (cefAppState) {
            return state_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void setState(final CefAppState cefAppState) {
        CefAppState cefAppState2 = state_;
        synchronized (cefAppState2) {
            state_ = cefAppState;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (appHandler_ != null) {
                    appHandler_.stateHasChanged(cefAppState);
                }
            }
        });
    }

    public final synchronized void dispose() {
        switch (CefApp.getState()) {
            case NEW: {
                CefApp.setState(CefAppState.TERMINATED);
                break;
            }
            case INITIALIZING: 
            case INITIALIZED: {
                CefApp.setState(CefAppState.SHUTTING_DOWN);
                if (this.clients_.isEmpty()) {
                    this.shutdown();
                    break;
                }
                HashSet<CefClient> hashSet = new HashSet<CefClient>(this.clients_);
                for (CefClient cefClient : hashSet) {
                    cefClient.dispose();
                }
                break;
            }
        }
    }

    public synchronized CefClient createClient() {
        switch (CefApp.getState()) {
            case NEW: {
                CefApp.setState(CefAppState.INITIALIZING);
                this.initialize();
            }
            case INITIALIZING: 
            case INITIALIZED: {
                CefClient cefClient = new CefClient();
                this.clients_.add(cefClient);
                return cefClient;
            }
        }
        throw new IllegalStateException("Can't crate client in state " + (Object)((Object)state_));
    }

    public boolean registerSchemeHandlerFactory(String string, String string2, CefSchemeHandlerFactory cefSchemeHandlerFactory) {
        try {
            return this.N_RegisterSchemeHandlerFactory(string, string2, cefSchemeHandlerFactory);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean clearSchemeHandlerFactories() {
        try {
            return this.N_ClearSchemeHandlerFactories();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    protected final synchronized void clientWasDisposed(CefClient cefClient) {
        this.clients_.remove(cefClient);
        if (this.clients_.isEmpty() && CefApp.getState().compareTo(CefAppState.SHUTTING_DOWN) >= 0) {
            this.shutdown();
        }
    }

    private final void initialize() {
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    CefSettings cefSettings;
                    String string = CefApp.getJcefLibPath();
                    System.out.println("initialize on " + Thread.currentThread() + " with library path " + string);
                    CefSettings cefSettings2 = cefSettings = CefApp.this.settings_ != null ? CefApp.this.settings_ : new CefSettings();
                    if (OS.isMacintosh()) {
                        if (cefSettings.browser_subprocess_path == null) {
                            Path path = Paths.get(string, "../Frameworks/jcef Helper.app/Contents/MacOS/jcef Helper");
                            cefSettings.browser_subprocess_path = path.normalize().toAbsolutePath().toString();
                        }
                    } else if (OS.isWindows()) {
                        if (cefSettings.browser_subprocess_path == null) {
                            Path path = Paths.get(string, "jcef_helper.exe");
                            cefSettings.browser_subprocess_path = path.normalize().toAbsolutePath().toString();
                        }
                    } else if (OS.isLinux()) {
                        Path path;
                        if (cefSettings.browser_subprocess_path == null) {
                            path = Paths.get(string, "jcef_helper");
                            cefSettings.browser_subprocess_path = path.normalize().toAbsolutePath().toString();
                        }
                        if (cefSettings.resources_dir_path == null) {
                            path = Paths.get(string, new String[0]);
                            cefSettings.resources_dir_path = path.normalize().toAbsolutePath().toString();
                        }
                        if (cefSettings.locales_dir_path == null) {
                            path = Paths.get(string, "locales");
                            cefSettings.locales_dir_path = path.normalize().toAbsolutePath().toString();
                        }
                    }
                    if (CefApp.this.N_Initialize(appHandler_, cefSettings)) {
                        CefApp.setState(CefAppState.INITIALIZED);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected final void handleBeforeTerminate() {
        System.out.println("Cmd+Q termination request.");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CefAppHandler cefAppHandler = (CefAppHandler)(appHandler_ == null ? this : appHandler_);
                if (!cefAppHandler.onBeforeTerminate()) {
                    CefApp.this.dispose();
                }
            }
        });
    }

    private final void shutdown() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.out.println("shutdown on " + Thread.currentThread());
                CefApp.this.N_Shutdown();
                CefApp.setState(CefAppState.TERMINATED);
                self = null;
            }
        });
    }

    public final void doMessageLoopWork(final long l) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CefApp.getState() == CefAppState.TERMINATED) {
                    return;
                }
                if (CefApp.this.workTimer_ != null) {
                    CefApp.this.workTimer_.stop();
                    CefApp.this.workTimer_ = null;
                }
                if (l <= 0L) {
                    CefApp.this.N_DoMessageLoopWork();
                    CefApp.this.doMessageLoopWork(33L);
                } else {
                    long l2 = l;
                    if (l2 > 33L) {
                        l2 = 33L;
                    }
                    CefApp.this.workTimer_ = new Timer((int)l2, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            CefApp.this.workTimer_.stop();
                            CefApp.this.workTimer_ = null;
                            CefApp.this.N_DoMessageLoopWork();
                            CefApp.this.doMessageLoopWork(33L);
                        }
                    });
                    CefApp.this.workTimer_.start();
                }
            }
        });
    }

    public static final boolean startup(String[] stringArray) {
        if (OS.isLinux() || OS.isMacintosh()) {
            SystemBootstrap.loadLibrary("jcef");
            return CefApp.N_Startup(OS.isMacintosh() ? CefApp.getCefFrameworkPath(stringArray) : null);
        }
        return true;
    }

    private static final String getJcefLibPath() {
        String[] stringArray;
        String string = System.getProperty("java.library.path");
        for (String string2 : stringArray = string.split(System.getProperty("path.separator"))) {
            File file = new File(string2);
            String[] stringArray2 = file.list(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.equalsIgnoreCase("libjcef.dylib") || string.equalsIgnoreCase("libjcef.so") || string.equalsIgnoreCase("jcef.dll");
                }
            });
            if (stringArray2 == null || stringArray2.length == 0) continue;
            return string2;
        }
        return string;
    }

    private static final String getCefFrameworkPath(String[] stringArray) {
        String string = "--framework-dir-path=";
        for (String string2 : stringArray) {
            if (!string2.startsWith(string)) continue;
            return new File(string2.substring(string.length())).getAbsolutePath();
        }
        return new File(CefApp.getJcefLibPath() + "/../Frameworks/Chromium Embedded Framework.framework").getAbsolutePath();
    }

    private static final native boolean N_Startup(String var0);

    private final native boolean N_PreInitialize();

    private final native boolean N_Initialize(CefAppHandler var1, CefSettings var2);

    private final native void N_Shutdown();

    private final native void N_DoMessageLoopWork();

    private final native CefVersion N_GetVersion();

    private final native boolean N_RegisterSchemeHandlerFactory(String var1, String var2, CefSchemeHandlerFactory var3);

    private final native boolean N_ClearSchemeHandlerFactories();

    public static enum CefAppState {
        NONE,
        NEW,
        INITIALIZING,
        INITIALIZED,
        SHUTTING_DOWN,
        TERMINATED;

    }

    public final class CefVersion {
        public final int JCEF_COMMIT_NUMBER;
        public final int CEF_VERSION_MAJOR;
        public final int CEF_VERSION_MINOR;
        public final int CEF_VERSION_PATCH;
        public final int CEF_COMMIT_NUMBER;
        public final int CHROME_VERSION_MAJOR;
        public final int CHROME_VERSION_MINOR;
        public final int CHROME_VERSION_BUILD;
        public final int CHROME_VERSION_PATCH;

        private CefVersion(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
            this.JCEF_COMMIT_NUMBER = n;
            this.CEF_VERSION_MAJOR = n2;
            this.CEF_VERSION_MINOR = n3;
            this.CEF_VERSION_PATCH = n4;
            this.CEF_COMMIT_NUMBER = n5;
            this.CHROME_VERSION_MAJOR = n6;
            this.CHROME_VERSION_MINOR = n7;
            this.CHROME_VERSION_BUILD = n8;
            this.CHROME_VERSION_PATCH = n9;
        }

        public String getJcefVersion() {
            return this.CEF_VERSION_MAJOR + "." + this.CEF_VERSION_MINOR + "." + this.CEF_VERSION_PATCH + "." + this.JCEF_COMMIT_NUMBER;
        }

        public String getCefVersion() {
            return this.CEF_VERSION_MAJOR + "." + this.CEF_VERSION_MINOR + "." + this.CEF_VERSION_PATCH;
        }

        public String getChromeVersion() {
            return this.CHROME_VERSION_MAJOR + "." + this.CHROME_VERSION_MINOR + "." + this.CHROME_VERSION_BUILD + "." + this.CHROME_VERSION_PATCH;
        }

        public String toString() {
            return "JCEF Version = " + this.getJcefVersion() + "\nCEF Version = " + this.getCefVersion() + "\nChromium Version = " + this.getChromeVersion();
        }
    }
}

