/*
 * Decompiled with CFR 0.152.
 */
package tests.detailed;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.cef.CefApp;
import org.cef.browser.CefBrowser;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLifeSpanHandlerAdapter;

public class BrowserFrame
extends JFrame {
    private boolean isClosed_ = false;
    private CefBrowser browser_ = null;
    private static int browserCount_ = 0;
    private Runnable afterParentChangedAction_ = null;

    public BrowserFrame() {
        this((String)null);
    }

    public BrowserFrame(String string) {
        super(string);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (BrowserFrame.this.browser_ == null) {
                    BrowserFrame.this.isClosed_ = true;
                    System.out.println("BrowserFrame.windowClosing Frame.dispose");
                    BrowserFrame.this.dispose();
                    return;
                }
                boolean bl = BrowserFrame.this.isClosed_;
                if (bl) {
                    BrowserFrame.this.browser_.setCloseAllowed();
                }
                System.out.println("BrowserFrame.windowClosing CefBrowser.close(" + bl + ")");
                BrowserFrame.this.browser_.close(bl);
                if (!BrowserFrame.this.isClosed_) {
                    BrowserFrame.this.isClosed_ = true;
                }
                if (bl) {
                    System.out.println("BrowserFrame.windowClosing Frame.dispose");
                    BrowserFrame.this.dispose();
                }
            }
        });
    }

    public void setBrowser(CefBrowser cefBrowser) {
        if (this.browser_ == null) {
            this.browser_ = cefBrowser;
        }
        this.browser_.getClient().removeLifeSpanHandler();
        this.browser_.getClient().addLifeSpanHandler((CefLifeSpanHandler)new CefLifeSpanHandlerAdapter(){

            public void onAfterCreated(CefBrowser cefBrowser) {
                System.out.println("BrowserFrame.onAfterCreated id=" + cefBrowser.getIdentifier());
                browserCount_++;
            }

            public void onAfterParentChanged(CefBrowser cefBrowser) {
                System.out.println("BrowserFrame.onAfterParentChanged id=" + cefBrowser.getIdentifier());
                if (BrowserFrame.this.afterParentChangedAction_ != null) {
                    SwingUtilities.invokeLater(BrowserFrame.this.afterParentChangedAction_);
                    BrowserFrame.this.afterParentChangedAction_ = null;
                }
            }

            public boolean doClose(CefBrowser cefBrowser) {
                boolean bl = cefBrowser.doClose();
                System.out.println("BrowserFrame.doClose id=" + cefBrowser.getIdentifier() + " CefBrowser.doClose=" + bl);
                return bl;
            }

            public void onBeforeClose(CefBrowser cefBrowser) {
                System.out.println("BrowserFrame.onBeforeClose id=" + cefBrowser.getIdentifier());
                if (--browserCount_ == 0) {
                    System.out.println("BrowserFrame.onBeforeClose CefApp.dispose");
                    CefApp.getInstance().dispose();
                }
            }
        });
    }

    public void removeBrowser(Runnable runnable) {
        System.out.println("BrowserFrame.removeBrowser");
        this.afterParentChangedAction_ = runnable;
        this.remove(this.browser_.getUIComponent());
        this.browser_.getUIComponent().removeNotify();
        this.browser_ = null;
    }

    public CefBrowser getBrowser() {
        return this.browser_;
    }
}

