/*
 * Decompiled with CFR 0.152.
 */
package tests.detailed;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JPanel;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.handler.CefAppHandler;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDisplayHandlerAdapter;
import org.cef.handler.CefDownloadHandler;
import org.cef.handler.CefDragHandler;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefFocusHandlerAdapter;
import org.cef.handler.CefJSDialogHandler;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.handler.CefRequestHandler;
import org.cef.network.CefCookieManager;
import tests.detailed.BrowserFrame;
import tests.detailed.dialog.DownloadDialog;
import tests.detailed.handler.AppHandler;
import tests.detailed.handler.ContextMenuHandler;
import tests.detailed.handler.DragHandler;
import tests.detailed.handler.JSDialogHandler;
import tests.detailed.handler.KeyboardHandler;
import tests.detailed.handler.MessageRouterHandler;
import tests.detailed.handler.MessageRouterHandlerEx;
import tests.detailed.handler.RequestHandler;
import tests.detailed.ui.ControlPanel;
import tests.detailed.ui.MenuBar;
import tests.detailed.ui.StatusPanel;
import tests.detailed.util.DataUri;

public class MainFrame
extends BrowserFrame {
    private static final long serialVersionUID = -2295538706810864538L;
    private final CefClient client_;
    private String errorMsg_ = "";
    private ControlPanel control_pane_;
    private StatusPanel status_panel_;
    private boolean browserFocus_ = true;

    public static void main(String[] stringArray) {
        if (!CefApp.startup((String[])stringArray)) {
            System.out.println("Startup initialization failed!");
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (String string : stringArray) {
            if ((string = string.toLowerCase()).equals("--off-screen-rendering-enabled")) {
                bl = true;
                continue;
            }
            if (string.equals("--transparent-painting-enabled")) {
                bl2 = true;
                continue;
            }
            if (!string.equals("--create-immediately")) continue;
            bl3 = true;
        }
        System.out.println("Offscreen rendering " + (bl ? "enabled" : "disabled"));
        MainFrame mainFrame = new MainFrame(bl, bl2, bl3, stringArray);
        mainFrame.setSize(800, 600);
        mainFrame.setVisible(true);
    }

    public MainFrame(boolean bl, boolean bl2, boolean bl3, String[] stringArray) {
        CefApp.CefVersion cefVersion;
        CefApp cefApp;
        Object object;
        if (CefApp.getState() != CefApp.CefAppState.INITIALIZED) {
            object = new CefSettings();
            object.windowless_rendering_enabled = bl;
            CefSettings cefSettings = object;
            cefSettings.getClass();
            object.background_color = new CefSettings.ColorType(cefSettings, 100, 255, 242, 211);
            cefApp = CefApp.getInstance((String[])stringArray, (CefSettings)object);
            cefVersion = cefApp.getVersion();
            System.out.println("Using:\n" + cefVersion);
            CefApp.addAppHandler((CefAppHandler)new AppHandler(stringArray));
        } else {
            cefApp = CefApp.getInstance();
        }
        this.client_ = cefApp.createClient();
        object = new DownloadDialog(this);
        this.client_.addContextMenuHandler((CefContextMenuHandler)new ContextMenuHandler(this));
        this.client_.addDownloadHandler((CefDownloadHandler)object);
        this.client_.addDragHandler((CefDragHandler)new DragHandler());
        this.client_.addJSDialogHandler((CefJSDialogHandler)new JSDialogHandler());
        this.client_.addKeyboardHandler((CefKeyboardHandler)new KeyboardHandler());
        this.client_.addRequestHandler((CefRequestHandler)new RequestHandler(this));
        cefVersion = CefMessageRouter.create();
        cefVersion.addHandler((CefMessageRouterHandler)new MessageRouterHandler(), true);
        cefVersion.addHandler((CefMessageRouterHandler)new MessageRouterHandlerEx(this.client_), false);
        this.client_.addMessageRouter((CefMessageRouter)cefVersion);
        this.client_.addDisplayHandler((CefDisplayHandler)new CefDisplayHandlerAdapter(){

            public void onAddressChange(CefBrowser cefBrowser, CefFrame cefFrame, String string) {
                MainFrame.this.control_pane_.setAddress(cefBrowser, string);
            }

            public void onTitleChange(CefBrowser cefBrowser, String string) {
                MainFrame.this.setTitle(string);
            }

            public void onStatusMessage(CefBrowser cefBrowser, String string) {
                MainFrame.this.status_panel_.setStatusText(string);
            }
        });
        this.client_.addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(){

            public void onLoadingStateChange(CefBrowser cefBrowser, boolean bl, boolean bl2, boolean bl3) {
                MainFrame.this.control_pane_.update(cefBrowser, bl, bl2, bl3);
                MainFrame.this.status_panel_.setIsInProgress(bl);
                if (!bl && !MainFrame.this.errorMsg_.isEmpty()) {
                    cefBrowser.loadURL(DataUri.create((String)"text/html", (String)MainFrame.this.errorMsg_));
                    MainFrame.this.errorMsg_ = "";
                }
            }

            public void onLoadError(CefBrowser cefBrowser, CefFrame cefFrame, CefLoadHandler.ErrorCode errorCode, String string, String string2) {
                if (errorCode != CefLoadHandler.ErrorCode.ERR_NONE && errorCode != CefLoadHandler.ErrorCode.ERR_ABORTED) {
                    MainFrame.this.errorMsg_ = "<html><head>";
                    MainFrame.this.errorMsg_ = MainFrame.this.errorMsg_ + "<title>Error while loading</title>";
                    MainFrame.this.errorMsg_ = MainFrame.this.errorMsg_ + "</head><body>";
                    MainFrame.this.errorMsg_ = MainFrame.this.errorMsg_ + "<h1>" + errorCode + "</h1>";
                    MainFrame.this.errorMsg_ = MainFrame.this.errorMsg_ + "<h3>Failed to load " + string2 + "</h3>";
                    MainFrame.this.errorMsg_ = MainFrame.this.errorMsg_ + "<p>" + (string == null ? "" : string) + "</p>";
                    MainFrame.this.errorMsg_ = MainFrame.this.errorMsg_ + "</body></html>";
                    cefBrowser.stopLoad();
                }
            }
        });
        CefBrowser cefBrowser = this.client_.createBrowser("http://www.google.com", bl, bl2, null);
        this.setBrowser(cefBrowser);
        JPanel jPanel = this.createContentPanel();
        this.getContentPane().add((Component)jPanel, "Center");
        this.control_pane_.getAddressField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (!MainFrame.this.browserFocus_) {
                    return;
                }
                MainFrame.this.browserFocus_ = false;
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                MainFrame.this.control_pane_.getAddressField().requestFocus();
            }
        });
        this.client_.addFocusHandler((CefFocusHandler)new CefFocusHandlerAdapter(){

            public void onGotFocus(CefBrowser cefBrowser) {
                if (MainFrame.this.browserFocus_) {
                    return;
                }
                MainFrame.this.browserFocus_ = true;
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                cefBrowser.setFocus(true);
            }

            public void onTakeFocus(CefBrowser cefBrowser, boolean bl) {
                MainFrame.this.browserFocus_ = false;
            }
        });
        if (bl3) {
            cefBrowser.createImmediately();
        }
        jPanel.add(this.getBrowser().getUIComponent(), "Center");
        MenuBar menuBar = new MenuBar(this, cefBrowser, this.control_pane_, (DownloadDialog)object, CefCookieManager.getGlobalManager());
        menuBar.addBookmark("Binding Test", "client://tests/binding_test.html");
        menuBar.addBookmark("Binding Test 2", "client://tests/binding_test2.html");
        menuBar.addBookmark("Download Test", "http://opensource.spotify.com/cefbuilds/index.html");
        menuBar.addBookmark("Login Test (username:pumpkin, password:pie)", "http://www.colostate.edu/~ric/protect/your.html");
        menuBar.addBookmark("Certificate-error Test", "https://www.k2go.de");
        menuBar.addBookmark("Resource-Handler Test", "http://www.foo.bar/");
        menuBar.addBookmark("Resource-Handler Set Error Test", "http://seterror.test/");
        menuBar.addBookmark("Scheme-Handler Test 1: (scheme \"client\")", "client://tests/handler.html");
        menuBar.addBookmark("Scheme-Handler Test 2: (scheme \"search\")", "search://do a barrel roll/");
        menuBar.addBookmark("Spellcheck Test", "client://tests/spellcheck.html");
        menuBar.addBookmark("LocalStorage Test", "client://tests/localstorage.html");
        menuBar.addBookmark("Transparency Test", "client://tests/transparency.html");
        menuBar.addBookmarkSeparator();
        menuBar.addBookmark("javachromiumembedded", "https://bitbucket.org/chromiumembedded/java-cef");
        menuBar.addBookmark("chromiumembedded", "https://bitbucket.org/chromiumembedded/cef");
        this.setJMenuBar(menuBar);
    }

    private JPanel createContentPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.control_pane_ = new ControlPanel(this.getBrowser());
        this.status_panel_ = new StatusPanel();
        jPanel.add((Component)this.control_pane_, "North");
        jPanel.add((Component)this.status_panel_, "South");
        return jPanel;
    }
}

