/*
 * Decompiled with CFR 0.152.
 */
package tests.detailed.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.cef.callback.CefCookieVisitor;
import org.cef.misc.BoolRef;
import org.cef.network.CefCookie;
import org.cef.network.CefCookieManager;

public class CookieManagerDialog
extends JDialog {
    private static int testCookieId = 1;
    private final CefCookieManager manager;
    private final CookieTableModel tblModel = new CookieTableModel();

    public CookieManagerDialog(Frame frame, String string, CefCookieManager cefCookieManager) {
        super(frame, string, false);
        this.setLayout(new BorderLayout());
        this.setSize(800, 600);
        this.manager = cefCookieManager;
        JTable jTable = new JTable(this.tblModel);
        jTable.setFillsViewportHeight(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JButton jButton = new JButton("Delete cookies");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CookieManagerDialog.this.tblModel.removeCookies();
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Add test cookie");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Date date = new Date();
                Date date2 = new Date(date.getTime() + 86400000L);
                String string = "testNo" + testCookieId++;
                CefCookie cefCookie = new CefCookie(string, "testCookie", ".test.cookie", "/", false, true, date, date, true, date2);
                if (CookieManagerDialog.this.manager.setCookie("http://my.test.cookie", cefCookie)) {
                    CookieManagerDialog.this.tblModel.visit(cefCookie, 1, 1, new BoolRef());
                }
            }
        });
        jPanel.add(jButton2);
        JButton jButton3 = new JButton("Done");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CookieManagerDialog.this.setVisible(false);
            }
        });
        jPanel.add(jButton3);
        this.add(new JScrollPane(jTable));
        this.add((Component)jPanel, "South");
        if (this.manager == null) {
            throw new NullPointerException("Cookie manager is null");
        }
        this.manager.visitAllCookies((CefCookieVisitor)this.tblModel);
    }

    private class CookieTableModel
    extends AbstractTableModel
    implements CefCookieVisitor {
        private final String[] columnNames;
        private Vector<Object[]> rowData = new Vector();

        public CookieTableModel() {
            this.columnNames = new String[]{"Name", "Value", "Domain", "Path", "Secure", "HTTP only", "Created", "Last Access", "Expires"};
        }

        public boolean visit(CefCookie cefCookie, int n, int n2, BoolRef boolRef) {
            Object[] objectArray = new Object[]{cefCookie.name, cefCookie.value, cefCookie.domain, cefCookie.path, new Boolean(cefCookie.secure), new Boolean(cefCookie.httponly), cefCookie.creation, cefCookie.lastAccess, cefCookie.expires};
            int n3 = this.rowData.size();
            this.rowData.addElement(objectArray);
            this.fireTableRowsInserted(n3, n3);
            return true;
        }

        public void removeCookies() {
            int n = this.rowData.size();
            if (n > 0) {
                this.rowData.clear();
                CookieManagerDialog.this.manager.deleteCookies("", "");
                this.fireTableRowsDeleted(0, n - 1);
            }
        }

        @Override
        public int getRowCount() {
            return this.rowData.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (this.rowData.size() > 0) {
                return this.rowData.get(0)[n].getClass();
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.rowData.get(n)[n2];
        }
    }
}

