/*
 * Decompiled with CFR 0.152.
 */
package tests.detailed.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.cef.OS;
import org.cef.browser.CefBrowser;

public class ControlPanel
extends JPanel {
    private final JButton backButton_;
    private final JButton forwardButton_;
    private final JButton reloadButton_;
    private final JTextField address_field_;
    private final JLabel zoom_label_;
    private double zoomLevel_ = 0.0;
    private final CefBrowser browser_;

    public ControlPanel(CefBrowser cefBrowser) {
        assert (cefBrowser != null);
        this.browser_ = cefBrowser;
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createHorizontalStrut(5));
        this.add(Box.createHorizontalStrut(5));
        this.backButton_ = new JButton("Back");
        this.backButton_.setFocusable(false);
        this.backButton_.setAlignmentX(0.0f);
        this.backButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.browser_.goBack();
            }
        });
        this.add(this.backButton_);
        this.add(Box.createHorizontalStrut(5));
        this.forwardButton_ = new JButton("Forward");
        this.forwardButton_.setFocusable(false);
        this.forwardButton_.setAlignmentX(0.0f);
        this.forwardButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.browser_.goForward();
            }
        });
        this.add(this.forwardButton_);
        this.add(Box.createHorizontalStrut(5));
        this.reloadButton_ = new JButton("Reload");
        this.reloadButton_.setFocusable(false);
        this.reloadButton_.setAlignmentX(0.0f);
        this.reloadButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ControlPanel.this.reloadButton_.getText().equalsIgnoreCase("reload")) {
                    int n;
                    int n2 = n = OS.isMacintosh() ? 4 : 2;
                    if ((actionEvent.getModifiers() & n) != 0) {
                        System.out.println("Reloading - ignoring cached values");
                        ControlPanel.this.browser_.reloadIgnoreCache();
                    } else {
                        System.out.println("Reloading - using cached values");
                        ControlPanel.this.browser_.reload();
                    }
                } else {
                    ControlPanel.this.browser_.stopLoad();
                }
            }
        });
        this.add(this.reloadButton_);
        this.add(Box.createHorizontalStrut(5));
        JLabel jLabel = new JLabel("Address:");
        jLabel.setAlignmentX(0.0f);
        this.add(jLabel);
        this.add(Box.createHorizontalStrut(5));
        this.address_field_ = new JTextField(100);
        this.address_field_.setAlignmentX(0.0f);
        this.address_field_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.browser_.loadURL(ControlPanel.this.getAddress());
            }
        });
        this.add(this.address_field_);
        this.add(Box.createHorizontalStrut(5));
        JButton jButton = new JButton("Go");
        jButton.setFocusable(false);
        jButton.setAlignmentX(0.0f);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.browser_.loadURL(ControlPanel.this.getAddress());
            }
        });
        this.add(jButton);
        this.add(Box.createHorizontalStrut(5));
        JButton jButton2 = new JButton("-");
        jButton2.setFocusable(false);
        jButton2.setAlignmentX(0.5f);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.browser_.setZoomLevel(ControlPanel.this.zoomLevel_ -= 1.0);
                ControlPanel.this.zoom_label_.setText(new Double(ControlPanel.this.zoomLevel_).toString());
            }
        });
        this.add(jButton2);
        this.zoom_label_ = new JLabel("0.0");
        this.add(this.zoom_label_);
        JButton jButton3 = new JButton("+");
        jButton3.setFocusable(false);
        jButton3.setAlignmentX(0.5f);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.browser_.setZoomLevel(ControlPanel.this.zoomLevel_ += 1.0);
                ControlPanel.this.zoom_label_.setText(new Double(ControlPanel.this.zoomLevel_).toString());
            }
        });
        this.add(jButton3);
    }

    public void update(CefBrowser cefBrowser, boolean bl, boolean bl2, boolean bl3) {
        if (cefBrowser == this.browser_) {
            this.backButton_.setEnabled(bl2);
            this.forwardButton_.setEnabled(bl3);
            this.reloadButton_.setText(bl ? "Abort" : "Reload");
        }
    }

    public String getAddress() {
        String string = this.address_field_.getText();
        try {
            string = string.replaceAll(" ", "%20");
            URI uRI = new URI(string);
            if (uRI.getScheme() != null) {
                return string;
            }
            if (uRI.getHost() != null && uRI.getPath() != null) {
                return string;
            }
            String string2 = uRI.getSchemeSpecificPart();
            if (string2.indexOf(46) == -1) {
                throw new URISyntaxException(string2, "No dot inside domain");
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            string = "search://" + string;
        }
        return string;
    }

    public void setAddress(CefBrowser cefBrowser, String string) {
        if (cefBrowser == this.browser_) {
            this.address_field_.setText(string);
        }
    }

    public JTextField getAddressField() {
        return this.address_field_;
    }
}

