/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.charts.transitions;

import com.codename1.charts.ChartComponent;
import com.codename1.charts.models.XYValueSeries;
import com.codename1.charts.transitions.SeriesTransition;

public class XYValueSeriesTransition
extends SeriesTransition {
    private final XYValueSeries series;
    private XYValueSeries cachedSeries;
    private XYValueSeries startVals;
    private XYValueSeries endVals;

    public XYValueSeriesTransition(ChartComponent chart, XYValueSeries series) {
        super(chart);
        this.series = series;
    }

    public void initTransition() {
        super.initTransition();
        this.startVals = new XYValueSeries("Start");
        this.copyValues(this.series, this.startVals);
        this.endVals = new XYValueSeries("End");
        this.copyValues(this.cachedSeries, this.endVals);
    }

    private void copyValues(XYValueSeries source, XYValueSeries target) {
        int len = source.getItemCount();
        for (int i = 0; i < len; ++i) {
            int index = target.getIndexForKey(source.getX(i));
            if (index > -1) {
                target.remove(index);
            }
            target.add(source.getX(i), source.getY(i), source.getValue(i));
        }
    }

    protected void cleanup() {
        super.cleanup();
        this.cachedSeries.clear();
    }

    protected void update(int progress) {
        double dProgress = progress;
        int len = this.endVals.getItemCount();
        for (int i = 0; i < len; ++i) {
            double x = this.endVals.getX(i);
            double y = this.endVals.getY(i);
            double val = this.endVals.getValue(i);
            int startIndex = this.startVals.getIndexForKey(x);
            int endindex = i;
            double startY = startIndex == -1 ? 0.0 : this.startVals.getY(startIndex);
            double endY = y;
            double tweenY = startY + (endY - startY) * dProgress / 100.0;
            double startVal = startIndex == -1 ? 0.0 : this.startVals.getValue(startIndex);
            double endVal = val;
            double tweenVal = startVal + (endVal - startVal) * dProgress / 100.0;
            int seriesIndex = this.series.getIndexForKey(x);
            if (seriesIndex > -1) {
                this.series.remove(seriesIndex);
            }
            this.series.add(x, tweenY, tweenVal);
        }
    }

    public XYValueSeries getBuffer() {
        if (this.cachedSeries == null) {
            this.cachedSeries = new XYValueSeries(this.series.getTitle());
        }
        return this.cachedSeries;
    }

    void setBuffer(XYValueSeries buffer) {
        this.cachedSeries = buffer;
    }

    public XYValueSeries getSeries() {
        return this.series;
    }
}

