/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.ui.Component;
import com.codename1.ui.EncodedImage;
import com.codename1.ui.Font;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.Label;

public class ComponentImage
extends Image {
    private Component cmp;
    private int w;
    private int h;
    private boolean pulsingAnimation;
    private double minPulsingAlpha = 0.2;
    private double maxPulsingAlpha = 1.0;
    private double pulsingStepSize = 1.0;
    private double pulsingCurrStep = 0.0;
    private boolean animation;

    public ComponentImage(Component cmp, int w, int h) {
        super(null);
        this.cmp = cmp;
        this.w = w;
        this.h = h;
    }

    ComponentImage(Component cmp) {
        super(null);
        this.cmp = cmp;
        this.w = cmp.getWidth();
        this.h = cmp.getHeight();
    }

    ComponentImage(int w, int h) {
        super(null);
        this.cmp = new Label();
        this.w = w;
        this.h = h;
    }

    public Component getComponent() {
        return this.cmp;
    }

    public void enablePulsingAnimation(double currStep, double stepSize, double minAlpha, double maxAlpha) {
        minAlpha = Math.min(1.0, Math.max(0.0, minAlpha));
        maxAlpha = Math.min(1.0, Math.max(0.0, maxAlpha));
        this.pulsingAnimation = true;
        this.pulsingCurrStep = currStep;
        this.pulsingStepSize = stepSize;
        this.minPulsingAlpha = minAlpha;
        this.maxPulsingAlpha = maxAlpha;
    }

    public void disablePulsingAnimation() {
        this.pulsingAnimation = false;
    }

    public boolean isPulsingAnimationEnabled() {
        return this.pulsingAnimation;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public void scale(int width, int height) {
        this.w = width;
        this.h = height;
    }

    public Image fill(int width, int height) {
        ComponentImage out = new ComponentImage(this.cmp);
        out.w = width;
        out.h = height;
        return out;
    }

    public Image applyMask(Object mask) {
        return new ComponentImage(this.cmp, this.w, this.h);
    }

    public void setAnimation(boolean anim) {
        this.animation = anim;
    }

    public boolean isAnimation() {
        return this.animation || this.pulsingAnimation;
    }

    public boolean requiresDrawImage() {
        return true;
    }

    protected void drawImage(Graphics g, Object nativeGraphics, int x, int y) {
        int tx = g.getTranslateX();
        int ty = g.getTranslateY();
        int oldX = this.cmp.getX();
        int oldY = this.cmp.getY();
        int oldW = this.cmp.getWidth();
        int oldH = this.cmp.getHeight();
        this.cmp.setX(x);
        this.cmp.setY(y);
        this.cmp.setWidth(this.w);
        this.cmp.setHeight(this.h);
        int col = g.getColor();
        g.setColor(65280);
        g.setColor(col);
        boolean antialias = g.isAntiAliased();
        g.setAntiAliased(true);
        int alpha = g.getAlpha();
        if (this.pulsingAnimation) {
            double sinVal = (Math.sin(this.pulsingCurrStep) + 1.0) / 2.0;
            sinVal = this.minPulsingAlpha + (this.maxPulsingAlpha - this.minPulsingAlpha) * sinVal;
            g.setAlpha((int)Math.round(sinVal * (double)alpha));
        }
        Font font = g.getFont();
        int color = g.getColor();
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        this.cmp.paintComponent(g, true);
        g.setFont(font);
        g.setColor(color);
        g.setClip(clipX, clipY, clipW, clipH);
        if (this.pulsingAnimation) {
            g.setAlpha(alpha);
        }
        g.setAntiAliased(antialias);
        this.cmp.setX(oldX);
        this.cmp.setY(oldY);
        this.cmp.setWidth(oldW);
        this.cmp.setHeight(oldH);
    }

    protected void drawImage(Graphics g, Object nativeGraphics, int x, int y, int w, int h) {
        int oldW = this.w;
        int oldH = this.h;
        this.drawImage(g, nativeGraphics, x, y);
        this.w = oldW;
        this.h = oldH;
    }

    public Image scaled(int width, int height) {
        return new ComponentImage(this.cmp, width, height);
    }

    public boolean animate() {
        if (this.pulsingAnimation) {
            this.pulsingCurrStep += this.pulsingStepSize;
            if (this.pulsingCurrStep >= Math.PI * 2) {
                this.pulsingCurrStep -= Math.PI * 2;
            }
        }
        this.cmp.animate();
        return this.pulsingAnimation || this.animation;
    }

    public EncodedImage toEncodedImage() {
        return new EncodedWrapper();
    }

    public class EncodedWrapper
    extends EncodedImage {
        EncodedWrapper() {
            super(ComponentImage.this.getWidth(), ComponentImage.this.getHeight());
        }

        public EncodedImage scaledEncoded(int width, int height) {
            return new ComponentImage(ComponentImage.this.cmp, width, height).toEncodedImage();
        }

        public Image scaled(int width, int height) {
            return new ComponentImage(ComponentImage.this.cmp, width, height).toEncodedImage();
        }

        protected Image getInternal() {
            return ComponentImage.this;
        }
    }
}

