/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.charts.views;

import com.codename1.charts.models.Point;
import com.codename1.charts.models.SeriesSelection;
import com.codename1.charts.views.PieSegment;
import com.codename1.ui.geom.Shape;
import com.codename1.util.MathUtil;
import java.util.ArrayList;
import java.util.List;

public class PieMapper {
    private final List<PieSegment> mPieSegmentList = new ArrayList<PieSegment>();
    private int mPieChartRadius;
    private int mCenterX;
    private int mCenterY;

    public void setDimensions(int pieRadius, int centerX, int centerY) {
        this.mPieChartRadius = pieRadius;
        this.mCenterX = centerX;
        this.mCenterY = centerY;
    }

    public boolean areAllSegmentPresent(int datasetSize) {
        return this.mPieSegmentList.size() == datasetSize;
    }

    public void addPieSegment(int dataIndex, float value, float startAngle, float angle) {
        this.mPieSegmentList.add(new PieSegment(dataIndex, value, startAngle, angle));
    }

    public void clearPieSegments() {
        this.mPieSegmentList.clear();
    }

    public double getAngle(Point screenPoint) {
        double dx = screenPoint.getX() - (float)this.mCenterX;
        double dy = -(screenPoint.getY() - (float)this.mCenterY);
        double inRads = MathUtil.atan2(dy, dx);
        inRads = inRads < 0.0 ? Math.abs(inRads) : Math.PI * 2 - inRads;
        return Math.toDegrees(inRads);
    }

    public boolean isOnPieChart(Point screenPoint) {
        double radiusSquared;
        double sqValue = MathUtil.pow((float)this.mCenterX - screenPoint.getX(), 2.0) + MathUtil.pow((float)this.mCenterY - screenPoint.getY(), 2.0);
        boolean isOnPieChart = sqValue <= (radiusSquared = (double)(this.mPieChartRadius * this.mPieChartRadius));
        return isOnPieChart;
    }

    public SeriesSelection getSeriesAndPointForScreenCoordinate(Point screenPoint) {
        if (this.isOnPieChart(screenPoint)) {
            double angleFromPieCenter = this.getAngle(screenPoint);
            for (PieSegment pieSeg : this.mPieSegmentList) {
                if (!pieSeg.isInSegment(angleFromPieCenter)) continue;
                return new SeriesSelection(0, pieSeg.getDataIndex(), pieSeg.getValue(), pieSeg.getValue());
            }
        }
        return null;
    }

    private Shape getSegmentShape(PieSegment segment) {
        return segment.getShape(this.mCenterX, this.mCenterY, this.mPieChartRadius);
    }

    private PieSegment getSegment(int dataIndex) {
        for (PieSegment s : this.mPieSegmentList) {
            if (dataIndex != s.getDataIndex()) continue;
            return s;
        }
        return null;
    }

    public Shape getSegmentShape(int dataIndex) {
        PieSegment seg = this.getSegment(dataIndex);
        if (seg != null) {
            return this.getSegmentShape(seg);
        }
        return null;
    }
}

