/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.processing;

import java.util.List;
import java.util.Map;
import java.util.Vector;

class ResultTokenizer {
    private final String expression;
    private final int length;
    private int pos;
    boolean predicate;

    ResultTokenizer(String expr) {
        if (expr == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        this.expression = expr;
        this.length = this.expression.length();
        this.pos = 0;
        this.predicate = false;
    }

    List tokenize(Map namespaceAliases) {
        Vector<String> tokens = new Vector<String>();
        this.pos = 0;
        String tok = this.next();
        while (!"".equals(tok)) {
            String mapto;
            int i;
            if (namespaceAliases != null && (i = tok.indexOf(58)) != -1 && (mapto = (String)namespaceAliases.get(tok.substring(0, i))) != null) {
                tok = mapto + tok.substring(i);
            }
            tokens.add(tok);
            tok = this.next();
        }
        return tokens;
    }

    private String getPredicate(StringBuffer sbuf) {
        int stack = 1;
        for (int i = this.pos; i < this.length; ++i) {
            char ch = this.expression.charAt(i);
            if (ResultTokenizer.isSubscript(ch)) {
                stack = ch == '[' ? ++stack : --stack;
            }
            if (stack == 0) {
                this.pos = i;
                this.predicate = false;
                break;
            }
            sbuf.append(ch);
        }
        return sbuf.toString();
    }

    private String next() {
        StringBuffer sbuf = new StringBuffer();
        if (this.pos >= this.length) {
            return sbuf.toString();
        }
        if (this.predicate) {
            return this.getPredicate(sbuf);
        }
        char del = this.expression.charAt(this.pos);
        if (ResultTokenizer.isDelimiter(del)) {
            if (del == '[') {
                this.predicate = true;
            } else if (ResultTokenizer.isSeparator(del)) {
                while (ResultTokenizer.isSeparator(this.expression.charAt(this.pos + 1))) {
                    sbuf.append(del);
                    ++this.pos;
                }
            }
            ++this.pos;
            sbuf.append(del);
            return sbuf.toString();
        }
        for (int i = this.pos; i < this.length; ++i) {
            char ch = this.expression.charAt(i);
            if (ResultTokenizer.isDelimiter(ch)) {
                this.pos = i;
                return sbuf.toString();
            }
            sbuf.append(ch);
        }
        this.pos = this.length;
        return sbuf.toString();
    }

    static boolean isSubscript(char ch) {
        switch (ch) {
            case '[': 
            case ']': {
                return true;
            }
        }
        return false;
    }

    static boolean isSeparator(char ch) {
        return ch == '/';
    }

    static boolean isDelimiter(char ch) {
        return ResultTokenizer.isSubscript(ch) || ResultTokenizer.isSeparator(ch);
    }
}

