/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.io.Log;
import com.codename1.io.Storage;
import com.codename1.io.Util;
import com.codename1.ui.Display;
import com.codename1.ui.EncodedImage;
import com.codename1.ui.Image;

public class StorageImageAsync
extends EncodedImage {
    private String fileName;
    private boolean changePending;
    private boolean imageCreated;
    private byte[] imageData;
    private Image placeholderImage;
    private boolean queued;
    private static final Object LOCK = new Object();

    private StorageImageAsync(String fileName, Image placeholderImage) {
        super(placeholderImage.getWidth(), placeholderImage.getHeight());
        this.fileName = fileName;
        this.placeholderImage = placeholderImage;
    }

    protected void resetCache() {
        super.resetCache();
    }

    protected Image getInternal() {
        if (this.imageData == null) {
            if (!this.queued) {
                this.getImageData();
            }
            return this.placeholderImage;
        }
        this.imageCreated = true;
        return super.getInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getImageData() {
        if (this.imageData != null) {
            return this.imageData;
        }
        Object object = LOCK;
        synchronized (object) {
            if (this.queued) {
                return null;
            }
            this.queued = true;
            Display.getInstance().scheduleBackgroundTask(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    Object i = null;
                    try {
                        try {
                            final byte[] imageDataLocal = (byte[])Storage.getInstance().readObject(StorageImageAsync.this.fileName);
                            Display.getInstance().callSerially(new Runnable(){

                                public void run() {
                                    StorageImageAsync.access$102(StorageImageAsync.this, imageDataLocal);
                                    StorageImageAsync.this.resetCache();
                                    StorageImageAsync.this.changePending = true;
                                    StorageImageAsync.this.imageCreated = false;
                                }
                            });
                        }
                        catch (Throwable ex) {
                            Log.e(ex);
                            Object var4_5 = null;
                            StorageImageAsync.this.queued = false;
                            Util.cleanup(i);
                            return;
                        }
                        Object var4_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        StorageImageAsync.this.queued = false;
                        Util.cleanup(i);
                        throw throwable;
                    }
                    StorageImageAsync.this.queued = false;
                    Util.cleanup(i);
                }
            });
        }
        return null;
    }

    public boolean animate() {
        if (this.changePending) {
            if (this.imageCreated) {
                this.changePending = false;
            }
            return true;
        }
        return false;
    }

    public boolean isAnimation() {
        return true;
    }

    public static StorageImageAsync create(String fileName, Image placeholder) {
        return new StorageImageAsync(fileName, placeholder);
    }

    static /* synthetic */ byte[] access$102(StorageImageAsync x0, byte[] x1) {
        x0.imageData = x1;
        return x1;
    }
}

