/*
 * Copyright (c) 2012, Codename One and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Codename One designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *  
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 * 
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * Please contact Codename One through http://www.codenameone.com/ if you 
 * need additional information or have any questions.
 */
package com.codename1.location;

/**
 * Listener interface for the Geofence background tracking functionality. Usage:
 * 
 * <script src="https://gist.github.com/codenameone/b0fa5280bde905a8f0cd.js"></script>
 *
 * @author Chen
 * 
 * @see LocationManager#isGeofenceSupported() 
 * @see LocationManager#addGeoFencing(java.lang.Class, com.codename1.location.Geofence) 
 * @see Geofence
 */
public interface GeofenceListener {
    
    /**
     * This callback gets called once the device is out of the Geofence area
     */ 
    public void onExit(String id);
    
    /**
     * This callback gets called once the device enters the Geofence area
     */ 
    public void onEntered(String id);
    
}
