/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.media;

import com.codename1.media.AbstractMedia;
import com.codename1.media.AsyncMedia;
import com.codename1.media.AudioBuffer;
import com.codename1.media.Media;
import com.codename1.media.MediaRecorderBuilder;
import com.codename1.media.RemoteControlListener;
import com.codename1.ui.Component;
import com.codename1.ui.Display;
import com.codename1.util.AsyncResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaManager {
    private static Map<String, AudioBuffer> audioBuffers = new HashMap<String, AudioBuffer>();
    private static RemoteControlListener remoteControlListener;

    public static AudioBuffer getAudioBuffer(String path) {
        return MediaManager.getAudioBuffer(path, false, 256);
    }

    public static AudioBuffer getAudioBuffer(String path, boolean create, int size) {
        AudioBuffer buf = null;
        if (create && !audioBuffers.containsKey(path)) {
            buf = new AudioBuffer(size);
            audioBuffers.put(path, buf);
        }
        buf = audioBuffers.get(path);
        buf.retain();
        return buf;
    }

    public static void releaseAudioBuffer(String path) {
        int refCount;
        AudioBuffer buf = audioBuffers.get(path);
        if (buf != null && (refCount = buf.release()) <= 0) {
            audioBuffers.remove(path);
        }
    }

    public static void deleteAudioBuffer(String path) {
        audioBuffers.remove(path);
    }

    public static void setRemoteControlListener(RemoteControlListener l) {
        boolean shouldStop;
        boolean bl = shouldStop = remoteControlListener != null && l == null;
        if (shouldStop) {
            Display.getInstance().stopRemoteControl();
        }
        boolean shouldStart = remoteControlListener == null && l != null;
        remoteControlListener = l;
        if (shouldStart) {
            Display.getInstance().startRemoteControl();
        }
    }

    public static RemoteControlListener getRemoteControlListener() {
        return remoteControlListener;
    }

    public static Media createBackgroundMedia(String uri) throws IOException {
        return Display.getInstance().createBackgroundMedia(uri);
    }

    public static AsyncResource<Media> createBackgroundMediaAsync(String uri) {
        return Display.getInstance().createBackgroundMediaAsync(uri);
    }

    public static Media createMedia(String uri, boolean isVideo) throws IOException {
        return MediaManager.createMedia(uri, isVideo, null);
    }

    public static Media createMedia(InputStream stream, String mimeType) throws IOException {
        return MediaManager.createMedia(stream, mimeType, null);
    }

    public static AsyncResource<Media> createMediaAsync(InputStream stream, String mimeType, Runnable onCompletion) {
        return Display.getInstance().createMediaAsync(stream, mimeType, onCompletion);
    }

    public static Media createMedia(String uri, boolean isVideo, Runnable onCompletion) throws IOException {
        return Display.getInstance().createMedia(uri, isVideo, onCompletion);
    }

    public static AsyncResource<Media> createMediaAsync(String uri, boolean isVideo, Runnable onCompletion) {
        return Display.getInstance().createMediaAsync(uri, isVideo, onCompletion);
    }

    public static void addCompletionHandler(Media media, Runnable onCompletion) {
        Display.getInstance().addCompletionHandler(media, onCompletion);
    }

    public static void removeCompletionHandler(Media media, Runnable onCompletion) {
        Display.getInstance().removeCompletionHandler(media, onCompletion);
    }

    public static Media createMedia(InputStream stream, String mimeType, Runnable onCompletion) throws IOException {
        return Display.getInstance().createMedia(stream, mimeType, onCompletion);
    }

    public static Media createMediaRecorder(String path) throws IOException {
        return MediaManager.createMediaRecorder(path, MediaManager.getAvailableRecordingMimeTypes()[0]);
    }

    public static String getMediaRecorderingMimeType() {
        return Display.getInstance().getMediaRecorderingMimeType();
    }

    public static String[] getAvailableRecordingMimeTypes() {
        return Display.getInstance().getAvailableRecordingMimeTypes();
    }

    public static Media createMediaRecorder(String path, String mimeType) throws IOException {
        return MediaManager.createMediaRecorder(new MediaRecorderBuilder().path(path).mimeType(mimeType));
    }

    public static Media createMediaRecorder(MediaRecorderBuilder builder) throws IOException {
        if (builder.isRedirectToAudioBuffer()) {
            return builder.build();
        }
        String mimeType = builder.getMimeType();
        if (mimeType == null && MediaManager.getAvailableRecordingMimeTypes().length > 0) {
            mimeType = MediaManager.getAvailableRecordingMimeTypes()[0];
        }
        String path = builder.getPath();
        boolean supportedMime = false;
        for (String mime : MediaManager.getAvailableRecordingMimeTypes()) {
            if (!mime.equals(mimeType)) continue;
            supportedMime = true;
            break;
        }
        if (!supportedMime) {
            throw new IllegalArgumentException("Mime type " + mimeType + " is not supported on this platform use getAvailableRecordingMimeTypes()");
        }
        return Display.getInstance().createMediaRecorder(path, mimeType);
    }

    public static AsyncMedia getAsyncMedia(final Media media) {
        if (media instanceof AsyncMedia) {
            return (AsyncMedia)media;
        }
        return new AbstractMedia(){

            protected void playImpl() {
                AsyncMedia.State oldState = this.getState();
                media.play();
                if (media.isPlaying() && oldState != AsyncMedia.State.Playing) {
                    this.fireMediaStateChange(AsyncMedia.State.Playing);
                }
                if (!media.isPlaying()) {
                    final Timer t = new Timer();
                    t.schedule(new TimerTask(){

                        public void run() {
                            if (media.isPlaying()) {
                                t.cancel();
                                this.fireMediaStateChange(AsyncMedia.State.Playing);
                            }
                        }
                    }, 50L, 50L);
                }
            }

            protected void pauseImpl() {
                AsyncMedia.State oldState = this.getState();
                media.pause();
                if (!media.isPlaying() && oldState != AsyncMedia.State.Paused) {
                    this.fireMediaStateChange(AsyncMedia.State.Paused);
                }
                if (media.isPlaying()) {
                    final Timer t = new Timer();
                    t.schedule(new TimerTask(){

                        public void run() {
                            if (!media.isPlaying()) {
                                t.cancel();
                                this.fireMediaStateChange(AsyncMedia.State.Paused);
                            }
                        }
                    }, 50L, 50L);
                }
            }

            public void prepare() {
                media.prepare();
            }

            public void cleanup() {
                media.cleanup();
            }

            public int getTime() {
                return media.getTime();
            }

            public void setTime(int time) {
                media.setTime(time);
            }

            public int getDuration() {
                return media.getDuration();
            }

            public void setVolume(int vol) {
                media.setVolume(vol);
            }

            public int getVolume() {
                return media.getVolume();
            }

            public boolean isPlaying() {
                return media.isPlaying();
            }

            public Component getVideoComponent() {
                return media.getVideoComponent();
            }

            public boolean isVideo() {
                return media.isVideo();
            }

            public boolean isFullScreen() {
                return media.isFullScreen();
            }

            public void setFullScreen(boolean fullScreen) {
                media.setFullScreen(fullScreen);
            }

            public void setNativePlayerMode(boolean nativePlayer) {
                media.setNativePlayerMode(nativePlayer);
            }

            public boolean isNativePlayerMode() {
                return media.isNativePlayerMode();
            }

            public void setVariable(String key, Object value) {
                media.setVariable(key, value);
            }

            public Object getVariable(String key) {
                return media.getVariable(key);
            }
        };
    }
}

