/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.processing;

import com.codename1.processing.StructuredContent;
import com.codename1.xml.Element;
import com.codename1.xml.XMLParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

class XMLContent
implements StructuredContent {
    private Element root;

    public XMLContent(Element content) {
        this.root = content;
    }

    public XMLContent(String content) {
        this(XMLContent.wrap(content));
    }

    private static Reader wrap(String content) {
        try {
            return new InputStreamReader((InputStream)new ByteArrayInputStream(content.getBytes("UTF-8")), "UTF-8");
        }
        catch (UnsupportedEncodingException err) {
            err.printStackTrace();
            return null;
        }
    }

    public XMLContent(InputStream content) {
        this(new XMLParser().parse(new InputStreamReader(content)));
    }

    public XMLContent(Reader content) {
        this(new XMLParser().parse(content));
    }

    public String toString() {
        if ("ROOT".equals(this.root.getTagName())) {
            return this.root.getChildAt(0).toString();
        }
        return this.getText();
    }

    private List _asStructuredContentArray(List array) {
        AbstractList children = array instanceof Vector ? new Vector() : new ArrayList();
        Iterator elements = array.iterator();
        while (elements.hasNext()) {
            children.add(new XMLContent((Element)elements.next()));
        }
        return children;
    }

    public List getChildren(String name) {
        return this._asStructuredContentArray(this.root.getChildrenByTagName(name));
    }

    public StructuredContent getChild(int index) {
        return new XMLContent(this.root.getChildAt(index));
    }

    public List getDescendants(String name) {
        return this._asStructuredContentArray(this.root.getDescendantsByTagName(name));
    }

    public String getAttribute(String name) {
        return this.root.getAttribute(name);
    }

    public Map getAttributes() {
        return this.root.getAttributes();
    }

    public StructuredContent getParent() {
        Element parent = this.root.getParent();
        if (parent == null) {
            return null;
        }
        return new XMLContent(parent);
    }

    public String getText() {
        if (this.root.isTextElement()) {
            return this.root.getText();
        }
        if (this.root.getNumChildren() == 0) {
            return "";
        }
        if (this.root.getChildAt(0).isTextElement()) {
            return this.root.getChildAt(0).getText();
        }
        return this.root.toString();
    }

    public Object getNativeRoot() {
        return this.root;
    }
}

