/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.io;

import com.codename1.io.CacheMap;
import com.codename1.io.Log;
import com.codename1.io.Util;
import com.codename1.util.StringUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Storage {
    private final CacheMap cache = new CacheMap();
    private static Storage INSTANCE;
    private boolean normalizeNames = true;

    public void setHardCacheSize(int size) {
        this.cache.setCacheSize(size);
    }

    private String fixFileName(String name) {
        if (this.normalizeNames) {
            name = StringUtil.replaceAll(name, "/", "_");
            name = StringUtil.replaceAll(name, "\\", "_");
            name = StringUtil.replaceAll(name, "%", "_");
            name = StringUtil.replaceAll(name, "?", "_");
            name = StringUtil.replaceAll(name, "*", "_");
            name = StringUtil.replaceAll(name, ":", "_");
            name = StringUtil.replaceAll(name, "=", "_");
        }
        return name;
    }

    private static void init(Object data) {
        if (Util.getImplementation() != null) {
            Util.getImplementation().setStorageData(data);
        }
        if (INSTANCE == null) {
            INSTANCE = new Storage();
        }
    }

    public static boolean isInitialized() {
        return INSTANCE != null;
    }

    public static Storage getInstance() {
        if (INSTANCE == null) {
            Storage.init("cn1");
        }
        return INSTANCE;
    }

    public void clearCache() {
        this.cache.clearAllCache();
    }

    public void flushStorageCache() {
        Util.getImplementation().flushStorageCache();
    }

    public void deleteStorageFile(String name) {
        name = this.fixFileName(name);
        Util.getImplementation().deleteStorageFile(name);
        this.cache.delete(name);
    }

    public void clearStorage() {
        Util.getImplementation().clearStorage();
        this.cache.clearAllCache();
    }

    public OutputStream createOutputStream(String name) throws IOException {
        name = this.fixFileName(name);
        return Util.getImplementation().createStorageOutputStream(name);
    }

    public InputStream createInputStream(String name) throws IOException {
        if (!this.exists(name)) {
            throw new IOException("Storage key " + name + " does not exist");
        }
        name = this.fixFileName(name);
        return Util.getImplementation().createStorageInputStream(name);
    }

    public boolean exists(String name) {
        name = this.fixFileName(name);
        return Util.getImplementation().storageFileExists(name);
    }

    public String[] listEntries() {
        return Util.getImplementation().listStorageEntries();
    }

    public int entrySize(String name) {
        name = this.fixFileName(name);
        return Util.getImplementation().getStorageEntrySize(name);
    }

    public boolean writeObject(String name, Object o) {
        name = this.fixFileName(name);
        this.cache.put(name, o);
        DataOutputStream d = null;
        try {
            d = new DataOutputStream(this.createOutputStream(name));
            Util.writeObject(o, d);
            d.close();
            return true;
        }
        catch (Exception err) {
            Log.e(err);
            if (Log.isCrashBound()) {
                Log.sendLog();
            }
            Util.getImplementation().deleteStorageFile(name);
            Util.getImplementation().cleanup(d);
            return false;
        }
    }

    public Object readObject(String name) {
        Object o = this.cache.get(name = this.fixFileName(name));
        if (o != null) {
            return o;
        }
        DataInputStream d = null;
        try {
            if (!this.exists(name)) {
                return null;
            }
            d = new DataInputStream(this.createInputStream(name));
            o = Util.readObject(d);
            d.close();
            this.cache.put(name, o);
            return o;
        }
        catch (Throwable err) {
            Log.p("Error while reading: " + name);
            Log.e(err);
            if (Log.isCrashBound()) {
                Log.sendLog();
            }
            Util.getImplementation().cleanup(d);
            return null;
        }
    }

    public boolean isNormalizeNames() {
        return this.normalizeNames;
    }

    public void setNormalizeNames(boolean normalizeNames) {
        this.normalizeNames = normalizeNames;
    }

    public static void setStorageInstance(Storage s) {
        INSTANCE = s;
    }
}

