/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maps;

import com.codename1.maps.BoundingBox;
import com.codename1.maps.Coord;
import com.codename1.maps.Tile;
import com.codename1.maps.providers.MapProvider;
import com.codename1.ui.Graphics;
import com.codename1.ui.util.WeakHashMap;

class CacheProviderProxy
extends MapProvider {
    private final MapProvider provider;
    private WeakHashMap _cache;
    private int _time;
    private int _maxSize;

    CacheProviderProxy(MapProvider provider) {
        super(provider.projection(), provider.tileSize());
        this.provider = provider;
        this._cache = new WeakHashMap();
        this._time = 0;
        this._maxSize = 100;
    }

    public int maxZoomLevel() {
        return this.provider.maxZoomLevel();
    }

    public Coord scale(int zoomLevel) {
        return this.provider.scale(zoomLevel);
    }

    public Tile tileFor(BoundingBox bbox) {
        Tile tile = this.get(bbox);
        if (tile == null) {
            tile = this.provider.tileFor(bbox);
            this.put(bbox, tile);
        }
        return tile;
    }

    public BoundingBox bboxFor(Coord position, int zoomLevel) {
        return this.provider.bboxFor(position, zoomLevel);
    }

    public String attribution() {
        return this.provider.attribution();
    }

    public MapProvider originalProvider() {
        return this.provider;
    }

    protected Tile get(BoundingBox bbox) {
        ++this._time;
        Object o = this._cache.get(bbox);
        if (o == null) {
            return null;
        }
        AgeableTile tile = (AgeableTile)o;
        tile.age = this._time;
        return tile;
    }

    protected void put(BoundingBox bbox, Tile tile) {
        this._cache.put(bbox, new AgeableTile(tile, this._time));
    }

    public void clearCache() {
        this._maxSize = 6;
        this._cache.clear();
    }

    class AgeableTile
    extends Tile {
        private Tile tile;
        public int age;

        public AgeableTile(Tile tile, int time) {
            super(tile.dimension(), tile.getBoundingBox(), null);
            this.tile = tile;
            this.age = time;
        }

        public boolean paint(Graphics g) {
            return this.tile.paint(g);
        }
    }
}

