/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.l10n;

import com.codename1.io.Util;
import com.codename1.l10n.DateFormatSymbols;
import com.codename1.l10n.ParseException;
import com.codename1.ui.Display;
import java.util.Calendar;
import java.util.Date;

public class L10NManager {
    private String language;
    private String locale;
    private DateFormatSymbols symbols;

    private DateFormatSymbols getSymbols() {
        if (this.symbols == null) {
            this.symbols = new DateFormatSymbols();
        }
        return this.symbols;
    }

    protected L10NManager(String language, String locale) {
        this.language = language;
        this.locale = locale;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLocale(String locale, String language) {
        this.language = language;
        this.locale = locale;
    }

    public String format(int number) {
        return "" + number;
    }

    public String format(double number) {
        return "" + number;
    }

    public String getShortMonthName(Date date) {
        return this.limitLength(this.getLongMonthName(date), 3);
    }

    public String getLongMonthName(Date date) {
        String fmt = this.formatDateLongStyle(date);
        try {
            return this.extractMonthName(fmt);
        }
        catch (ParseException ex) {
            int v = Calendar.getInstance().get(2) - 0;
            return this.getSymbols().getMonths()[v];
        }
    }

    private String limitLength(String s, int len) {
        if (s.length() > len) {
            return s.substring(0, len);
        }
        return s;
    }

    private String extractMonthName(String dateStr) throws ParseException {
        String[] parts;
        for (String part : parts = Util.split(dateStr, " ")) {
            String firstChar;
            if (part.length() == 0 || part.toLowerCase().equals("de") || (firstChar = part.substring(0, 1)).toLowerCase().equals(firstChar.toUpperCase())) continue;
            return part;
        }
        throw new ParseException("Cannot extract month from string", 0);
    }

    public String formatCurrency(double currency) {
        return "" + currency;
    }

    public String getCurrencySymbol() {
        return "$";
    }

    public String formatDateLongStyle(Date d) {
        return d.toString();
    }

    public String formatDateShortStyle(Date d) {
        return d.toString();
    }

    public String formatDateTime(Date d) {
        return d.toString();
    }

    public String formatDateTimeMedium(Date d) {
        return d.toString();
    }

    public String formatTime(Date d) {
        String s = this.formatDateTimeMedium(d);
        int pos = s.lastIndexOf(" ");
        if (s.length() - pos < 4) {
            pos = s.lastIndexOf(" ", pos - 1);
        }
        s = s.substring(pos + 1);
        return s;
    }

    public String formatDateTimeShort(Date d) {
        return d.toString();
    }

    public boolean isRTLLocale() {
        return "iw".equals(this.language) || "ar".equals(this.language);
    }

    public String getLocale() {
        return this.locale;
    }

    public static L10NManager getInstance() {
        return Display.getInstance().getLocalizationManager();
    }

    public String format(double number, int decimalPlaces) {
        if (decimalPlaces == 0) {
            return this.format((long)number);
        }
        double pos = 10.0;
        for (int iter = 1; iter < decimalPlaces; ++iter) {
            pos *= 10.0;
        }
        long ln = Math.round(number * pos);
        number = (double)ln / pos;
        return this.format(number);
    }

    public double parseDouble(String localeFormattedDecimal) {
        return Double.parseDouble(localeFormattedDecimal);
    }

    public long parseLong(String localeFormattedLong) {
        return Long.parseLong(localeFormattedLong);
    }

    public int parseInt(String localeFormattedInteger) {
        return Integer.parseInt(localeFormattedInteger);
    }

    public double parseCurrency(String amount) {
        StringBuilder b = new StringBuilder();
        int l = amount.length();
        for (int iter = 0; iter < l; ++iter) {
            char c = amount.charAt(iter);
            if (!Character.isDigit(c) && c != '.' && c != ',' && c != '-') continue;
            b.append(c);
        }
        return this.parseDouble(b.toString());
    }
}

