/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.animations;

import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.InterFormContainer;
import com.codename1.ui.animations.Animation;
import java.util.Map;

public abstract class Transition
implements Animation {
    private Component source;
    private Component destination;
    private Map<InterFormContainer, InterFormContainer> interFormContainers;

    public final void init(Component source, Component destination) {
        this.source = source;
        this.destination = destination;
        if (source != null && source instanceof Container) {
            ((Container)source).layoutContainer();
        }
        if (destination != null && destination instanceof Container) {
            ((Container)destination).layoutContainer();
        }
        this.interFormContainers = InterFormContainer.findCommonContainers(this.getSource(), this.getDestination());
    }

    protected void hideInterformContainers() {
        if (!(this.getSource() instanceof Form) || !(this.getDestination() instanceof Form)) {
            return;
        }
        if (this.interFormContainers == null) {
            this.interFormContainers = InterFormContainer.findCommonContainers(this.getSource(), this.getDestination());
        }
        for (Map.Entry<InterFormContainer, InterFormContainer> e : this.interFormContainers.entrySet()) {
            e.getKey().setVisible(false);
            e.getValue().setVisible(false);
        }
    }

    protected void showInterformContainers() {
        if (!(this.getSource() instanceof Form) || !(this.getDestination() instanceof Form)) {
            return;
        }
        if (this.interFormContainers == null) {
            this.interFormContainers = InterFormContainer.findCommonContainers(this.getSource(), this.getDestination());
        }
        for (Map.Entry<InterFormContainer, InterFormContainer> e : this.interFormContainers.entrySet()) {
            e.getKey().setVisible(true);
            e.getValue().setVisible(true);
        }
    }

    protected void paintInterformContainers(Graphics g) {
        if (!(this.getSource() instanceof Form) || !(this.getDestination() instanceof Form)) {
            return;
        }
        if (this.interFormContainers == null) {
            this.interFormContainers = InterFormContainer.findCommonContainers(this.getSource(), this.getDestination());
        }
        this.showInterformContainers();
        for (Map.Entry<InterFormContainer, InterFormContainer> e : this.interFormContainers.entrySet()) {
            e.getKey().paintComponentBackground(g);
            e.getKey().paintComponent(g, false);
        }
    }

    public void initTransition() {
    }

    public final Component getDestination() {
        return this.destination;
    }

    public final Component getSource() {
        return this.source;
    }

    public void cleanup() {
        this.source = null;
        this.destination = null;
    }

    public Transition copy(boolean reverse) {
        return this;
    }

    protected final void cleanSource() {
        this.source = null;
    }

    public abstract boolean animate();

    public abstract void paint(Graphics var1);
}

