/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.list;

import com.codename1.cloud.CloudObject;
import com.codename1.ui.Button;
import com.codename1.ui.CheckBox;
import com.codename1.ui.Command;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.EncodedImage;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.Label;
import com.codename1.ui.List;
import com.codename1.ui.RadioButton;
import com.codename1.ui.Slider;
import com.codename1.ui.TextArea;
import com.codename1.ui.URLImage;
import com.codename1.ui.animations.Animation;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.list.CellRenderer;
import com.codename1.ui.list.ListCellRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericListCellRenderer<T>
implements ListCellRenderer<T>,
CellRenderer<T> {
    private Button lastClickedComponent;
    private ArrayList<Image> pendingAnimations;
    public static final String ENABLED = "$$ENABLED$$";
    public static final String SELECT_ALL_FLAG = "$$SELECTALL$$";
    private Label focusComponent = new Label();
    private Component selected;
    private Component unselected;
    private Component[] selectedEntries;
    private Component[] unselectedEntries;
    private Component selectedEven;
    private Component unselectedEven;
    private Component[] selectedEntriesEven;
    private Component[] unselectedEntriesEven;
    private Monitor mon = new Monitor();
    private Component parentList;
    private boolean selectionListener = true;
    private boolean firstCharacterRTL;
    private boolean fisheye;
    private boolean waitingForRegisterAnimation;
    private HashMap<String, EncodedImage> placeholders = new HashMap();
    private static URLImage.ImageAdapter defaultAdapter = URLImage.RESIZE_SCALE;
    private URLImage.ImageAdapter adapter = defaultAdapter;

    public static URLImage.ImageAdapter getDefaultAdapter() {
        return defaultAdapter;
    }

    public static void setDefaultAdapter(URLImage.ImageAdapter aDefaultAdapter) {
        defaultAdapter = aDefaultAdapter;
    }

    public GenericListCellRenderer(Component selected, Component unselected) {
        if (selected == unselected) {
            throw new IllegalArgumentException("Must use distinct instances for renderer!");
        }
        this.selected = selected;
        this.unselected = unselected;
        this.focusComponent.setUIID(selected.getUIID() + "Focus");
        this.focusComponent.setFocus(true);
        this.selectedEntries = this.initRenderer(selected);
        this.unselectedEntries = this.initRenderer(unselected);
        this.firstCharacterRTL = selected.getUIManager().isThemeConstant("firstCharRTLBool", false);
        this.addSelectedEntriesListener(this.selectedEntries);
        this.addSelectedEntriesListener(this.unselectedEntries);
    }

    void deinitialize(List l) {
        this.removeSelectedEntriesListener(this.selectedEntries);
        this.removeSelectedEntriesListener(this.unselectedEntries);
        l.removeActionListener((ActionListener)this.mon);
    }

    public void updateIconPlaceholders() {
        this.updateIconPlaceholders(this.selectedEntries);
        this.updateIconPlaceholders(this.unselectedEntries);
    }

    private void updateIconPlaceholders(Component[] e) {
        int elen = e.length;
        for (int iter = 0; iter < elen; ++iter) {
            String n = e[iter].getName();
            if (n == null || !n.endsWith("_URLImage") || !(e[iter] instanceof Label)) continue;
            this.placeholders.put(n, (EncodedImage)((Label)e[iter]).getIcon());
        }
    }

    private void removeSelectedEntriesListener(Component[] e) {
        int elen = e.length;
        for (int iter = 0; iter < elen; ++iter) {
            if (!(e[iter] instanceof Button)) continue;
            ((Button)e[iter]).removeActionListener((ActionListener)this.mon);
        }
    }

    private void addSelectedEntriesListener(Component[] e) {
        int elen = e.length;
        for (int iter = 0; iter < elen; ++iter) {
            String n;
            if (e[iter] instanceof Button) {
                ((Button)e[iter]).addActionListener((ActionListener)this.mon);
            }
            if ((n = e[iter].getName()) == null || !n.endsWith("_URLImage") || !(e[iter] instanceof Label)) continue;
            this.placeholders.put(n, (EncodedImage)((Label)e[iter]).getIcon());
        }
    }

    private Component[] initRenderer(Component r) {
        r.setCellRenderer(true);
        if (r instanceof Container) {
            ArrayList selectedVector = new ArrayList();
            this.findComponentsOfInterest(r, selectedVector);
            return this.vectorToComponentArray(selectedVector);
        }
        return new Component[]{r};
    }

    public Button extractLastClickedComponent() {
        Button c = this.lastClickedComponent;
        this.lastClickedComponent = null;
        return c;
    }

    public GenericListCellRenderer(Component odd, Component oddUnselected, Component even, Component evenUnselected) {
        this(odd, oddUnselected);
        this.selectedEven = even;
        this.unselectedEven = evenUnselected;
        this.selectedEntriesEven = super.initRenderer(even);
        this.unselectedEntriesEven = super.initRenderer(evenUnselected);
        super.addSelectedEntriesListener(this.selectedEntriesEven);
        super.addSelectedEntriesListener(this.unselectedEntriesEven);
    }

    private Component[] vectorToComponentArray(ArrayList v) {
        Component[] result = new Component[v.size()];
        int rlen = result.length;
        for (int iter = 0; iter < rlen; ++iter) {
            result[iter] = (Component)v.get(iter);
        }
        return result;
    }

    private void findComponentsOfInterest(Component cmp, ArrayList dest) {
        if (cmp instanceof Container) {
            Container c = (Container)cmp;
            int count = c.getComponentCount();
            for (int iter = 0; iter < count; ++iter) {
                this.findComponentsOfInterest(c.getComponentAt(iter), dest);
            }
            return;
        }
        if (cmp.getName() != null) {
            if (cmp instanceof Label) {
                Label l = (Label)cmp;
                if (l.getName().toLowerCase().endsWith("fixed") && l.getIcon() != null) {
                    l.getIcon().lock();
                }
                dest.add(cmp);
                return;
            }
            if (cmp instanceof TextArea) {
                dest.add(cmp);
                return;
            }
        }
    }

    @Override
    public Component getCellRendererComponent(Component list, Object model, T value, int index, boolean isSelected) {
        if (!this.fisheye && !Display.getInstance().shouldRenderSelection(list)) {
            isSelected = false;
        }
        if (isSelected && (this.fisheye || list.hasFocus())) {
            Component cmp = this.selected;
            Component[] entries = this.selectedEntries;
            if (this.selectedEven != null && index % 2 == 0) {
                cmp = this.selectedEven;
                entries = this.selectedEntriesEven;
                if (list instanceof List) {
                    ((List)list).setMutableRendererBackgrounds(true);
                }
            }
            cmp.setFocus(true);
            boolean lead = false;
            if (cmp instanceof Container) {
                boolean bl = lead = ((Container)cmp).getLeadComponent() != null;
            }
            if (value instanceof Map) {
                Map h = (Map)value;
                Boolean enabled = (Boolean)h.get(ENABLED);
                if (enabled != null) {
                    cmp.setEnabled(enabled);
                }
                int elen = entries.length;
                for (int iter = 0; iter < elen; ++iter) {
                    Object val;
                    String currentName = entries[iter].getName();
                    if (currentName.equals("$number")) {
                        val = "" + (index + 1);
                    } else {
                        val = h.get("#" + currentName);
                        if (val == null) {
                            val = h.get(currentName);
                        }
                        val = this.updateModelValues(h, currentName, entries, iter, val);
                    }
                    this.setComponentValueWithTickering(entries[iter], val, list, cmp);
                    entries[iter].setFocus(lead || entries[iter].isFocusable());
                }
            } else if (value instanceof CloudObject) {
                CloudObject h = (CloudObject)value;
                Boolean enabled = h.getBoolean(ENABLED);
                if (enabled != null) {
                    cmp.setEnabled(enabled);
                }
                int elen = entries.length;
                for (int iter = 0; iter < elen; ++iter) {
                    Object val;
                    String currentName = entries[iter].getName();
                    if (currentName.equals("$number")) {
                        val = "" + (index + 1);
                    } else {
                        val = h.getObject("#" + currentName);
                        if (val == null) {
                            val = h.getObject(currentName);
                        }
                    }
                    this.setComponentValueWithTickering(entries[iter], val, list, cmp);
                    entries[iter].setFocus(entries[iter].isFocusable());
                }
            } else {
                this.setComponentValueWithTickering(entries[0], value, list, cmp);
                entries[0].setFocus(entries[0].isFocusable());
            }
            return cmp;
        }
        Component cmp = this.unselected;
        Component[] entries = this.unselectedEntries;
        if (this.unselectedEven != null && index % 2 == 0) {
            cmp = this.unselectedEven;
            entries = this.unselectedEntriesEven;
            if (list instanceof List) {
                ((List)list).setMutableRendererBackgrounds(true);
            }
        }
        cmp.setFocus(false);
        if (value instanceof Map) {
            Map h = (Map)value;
            Boolean enabled = (Boolean)h.get(ENABLED);
            if (enabled != null) {
                cmp.setEnabled(enabled);
            }
            int elen = entries.length;
            for (int iter = 0; iter < elen; ++iter) {
                String currentName = entries[iter].getName();
                if (currentName.equals("$number")) {
                    this.setComponentValue(entries[iter], "" + (index + 1), list, cmp);
                    continue;
                }
                Object val = h.get(currentName);
                val = this.updateModelValues(h, currentName, entries, iter, val);
                this.setComponentValue(entries[iter], val, list, cmp);
            }
        } else if (value instanceof CloudObject) {
            CloudObject h = (CloudObject)value;
            Boolean enabled = h.getBoolean(ENABLED);
            if (enabled != null) {
                cmp.setEnabled(enabled);
            }
            int elen = entries.length;
            for (int iter = 0; iter < elen; ++iter) {
                String currentName = entries[iter].getName();
                if (currentName.equals("$number")) {
                    this.setComponentValue(entries[iter], "" + (index + 1), list, cmp);
                    continue;
                }
                this.setComponentValue(entries[iter], h.getObject(currentName), list, cmp);
            }
        } else if (entries.length > 0) {
            this.setComponentValue(entries[0], value, list, cmp);
        }
        return cmp;
    }

    private Object updateModelValues(Map h, String currentName, Component[] entries, int iter, Object val) {
        String uiid = (String)h.get(currentName + "_uiid");
        if (uiid != null) {
            entries[iter].setUIID(uiid);
        }
        if (currentName.endsWith("_URLImage")) {
            URLImage img = (URLImage)h.get(currentName + "Actual");
            if (img != null) {
                val = img;
            } else {
                String name = (String)h.get(currentName + "Name");
                if (name == null) {
                    name = val.toString();
                    name = name.substring(name.lastIndexOf(47));
                }
                val = URLImage.createToStorage(this.placeholders.get(currentName), name, val.toString(), this.adapter);
                h.put(currentName + "Actual", val);
            }
        }
        return val;
    }

    @Override
    public Component getListCellRendererComponent(List list, T value, int index, boolean isSelected) {
        return this.getCellRendererComponent(list, list.getModel(), value, index, isSelected);
    }

    private boolean isSelectedValue(Object v) {
        return v != null && "true".equalsIgnoreCase(v.toString());
    }

    private void setComponentValueWithTickering(Component cmp, Object value, Component l, Component rootRenderer) {
        this.setComponentValue(cmp, value, l, rootRenderer);
        if (cmp instanceof Label) {
            Label label;
            if (this.selectionListener) {
                if (l instanceof List) {
                    ((List)l).addActionListener((ActionListener)this.mon);
                }
                this.parentList = l;
            }
            if ((label = (Label)cmp).shouldTickerStart() && Display.getInstance().shouldRenderSelection()) {
                if (!label.isTickerRunning()) {
                    Form f;
                    this.parentList = l;
                    if (this.parentList != null && (f = this.parentList.getComponentForm()) != null) {
                        f.registerAnimated(this.mon);
                        label.startTicker(cmp.getUIManager().getLookAndFeel().getTickerSpeed(), true);
                    }
                }
            } else {
                if (label.isTickerRunning()) {
                    label.stopTicker();
                }
                label.setTextPosition(0);
            }
        }
    }

    private void setComponentValue(Component cmp, Object value, Component parent, Component rootRenderer) {
        if (cmp.getName().toLowerCase().endsWith("fixed")) {
            return;
        }
        if (cmp instanceof Label) {
            String t;
            if (value instanceof Image) {
                Image i = (Image)value;
                if (i.isAnimation()) {
                    Form f;
                    if (this.pendingAnimations == null) {
                        this.pendingAnimations = new ArrayList();
                    }
                    if (!this.pendingAnimations.contains(i)) {
                        this.pendingAnimations.add(i);
                        if (this.parentList == null) {
                            this.parentList = parent;
                        }
                        if (this.parentList != null) {
                            f = this.parentList.getComponentForm();
                            if (f != null) {
                                f.registerAnimated(this.mon);
                                this.waitingForRegisterAnimation = false;
                            } else {
                                this.waitingForRegisterAnimation = true;
                            }
                        }
                    } else if (this.waitingForRegisterAnimation && this.parentList != null && (f = this.parentList.getComponentForm()) != null) {
                        f.registerAnimated(this.mon);
                        this.waitingForRegisterAnimation = false;
                    }
                }
                Image oldImage = ((Label)cmp).getIcon();
                ((Label)cmp).setIcon(i);
                ((Label)cmp).setText("");
                if (oldImage == null || oldImage.getWidth() != i.getWidth() || oldImage.getHeight() != i.getHeight()) {
                    ((Container)rootRenderer).revalidate();
                }
                return;
            }
            ((Label)cmp).setIcon(null);
            if (cmp instanceof CheckBox) {
                ((CheckBox)cmp).setSelected(this.isSelectedValue(value));
                return;
            }
            if (cmp instanceof RadioButton) {
                ((RadioButton)cmp).setSelected(this.isSelectedValue(value));
                return;
            }
            if (cmp instanceof Slider) {
                ((Slider)cmp).setProgress((Integer)value);
                return;
            }
            Label l = (Label)cmp;
            if (value == null) {
                l.setText("");
            } else if (value instanceof Label) {
                l.setText(((Label)value).getText());
                l.setIcon(((Label)value).getIcon());
            } else {
                l.setText(value.toString());
            }
            if (this.firstCharacterRTL && (t = l.getText()).length() > 0) {
                l.setRTL(Display.getInstance().isRTL(t.charAt(0)));
            }
            return;
        }
        if (cmp instanceof TextArea) {
            if (value == null) {
                ((TextArea)cmp).setText("");
            } else {
                ((TextArea)cmp).setText(value.toString());
            }
        }
    }

    @Override
    public Component getListFocusComponent(List list) {
        return this.focusComponent;
    }

    @Override
    public Component getFocusComponent(Component list) {
        return this.focusComponent;
    }

    public boolean isSelectionListener() {
        return this.selectionListener;
    }

    public void setSelectionListener(boolean selectionListener) {
        if (this.parentList != null && this.parentList instanceof List) {
            ((List)this.parentList).addActionListener((ActionListener)this.mon);
        }
        this.selectionListener = selectionListener;
    }

    public Component getSelected() {
        return this.selected;
    }

    public Component getUnselected() {
        return this.unselected;
    }

    public Component getSelectedEven() {
        return this.selectedEven;
    }

    public Component getUnselectedEven() {
        return this.unselectedEven;
    }

    public boolean isFisheye() {
        return this.fisheye;
    }

    public void setFisheye(boolean fisheye) {
        this.fisheye = fisheye;
    }

    public URLImage.ImageAdapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(URLImage.ImageAdapter adapter) {
        this.adapter = adapter;
    }

    class Monitor
    implements ActionListener,
    Animation {
        private boolean selectAllChecked;
        private int selectAllOffset;

        Monitor() {
        }

        public boolean animate() {
            boolean hasAnimations = false;
            if (GenericListCellRenderer.this.parentList != null) {
                Form f;
                boolean repaint = false;
                if (GenericListCellRenderer.this.pendingAnimations != null && GenericListCellRenderer.this.pendingAnimations.size() > 0) {
                    int s = GenericListCellRenderer.this.pendingAnimations.size();
                    hasAnimations = true;
                    for (int iter = 0; iter < s; ++iter) {
                        Image i = (Image)GenericListCellRenderer.this.pendingAnimations.get(iter);
                        repaint = i.animate() || repaint;
                    }
                    if (repaint) {
                        GenericListCellRenderer.this.pendingAnimations.clear();
                    } else if (GenericListCellRenderer.this.pendingAnimations.size() > 20) {
                        repaint = true;
                    }
                }
                if ((f = GenericListCellRenderer.this.parentList.getComponentForm()) != null) {
                    int slen;
                    if (GenericListCellRenderer.this.parentList.hasFocus() && Display.getInstance().shouldRenderSelection(GenericListCellRenderer.this.parentList)) {
                        slen = GenericListCellRenderer.this.selectedEntries.length;
                        for (int iter = 0; iter < slen; ++iter) {
                            Label l;
                            if (!(GenericListCellRenderer.this.selectedEntries[iter] instanceof Label) || !(l = (Label)GenericListCellRenderer.this.selectedEntries[iter]).isTickerRunning()) continue;
                            repaint = true;
                            l.animate();
                        }
                    } else {
                        slen = GenericListCellRenderer.this.selectedEntries.length;
                        for (int iter = 0; iter < slen; ++iter) {
                            Label l;
                            if (!(GenericListCellRenderer.this.selectedEntries[iter] instanceof Label) || !(l = (Label)GenericListCellRenderer.this.selectedEntries[iter]).isTickerRunning()) continue;
                            l.stopTicker();
                            repaint = true;
                        }
                    }
                    if (repaint) {
                        GenericListCellRenderer.this.parentList.repaint();
                    } else if (!hasAnimations) {
                        f.deregisterAnimated(this);
                    }
                    return false;
                }
                if (repaint) {
                    GenericListCellRenderer.this.parentList.repaint();
                }
            }
            return false;
        }

        public void paint(Graphics g) {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getComponent() instanceof Button) {
                GenericListCellRenderer.this.lastClickedComponent = (Button)evt.getComponent();
                return;
            }
            if (GenericListCellRenderer.this.parentList instanceof List) {
                GenericListCellRenderer.this.parentList.setHandlesInput(true);
                Object selection = ((List)GenericListCellRenderer.this.parentList).getSelectedItem();
                if (selection instanceof Map) {
                    Map h = (Map)selection;
                    Command cmd = (Command)h.get("$navigation");
                    if (cmd != null) {
                        GenericListCellRenderer.this.parentList.getComponentForm().dispatchCommand(cmd, new ActionEvent((Object)cmd, ActionEvent.Type.Command));
                        return;
                    }
                    int slen = GenericListCellRenderer.this.selectedEntries.length;
                    for (int iter = 0; iter < slen; ++iter) {
                        boolean sel;
                        if (!(GenericListCellRenderer.this.selectedEntries[iter] instanceof CheckBox) && !(GenericListCellRenderer.this.selectedEntries[iter] instanceof RadioButton)) continue;
                        boolean bl = sel = !GenericListCellRenderer.this.isSelectedValue(h.get(GenericListCellRenderer.this.selectedEntries[iter].getName()));
                        if (h.get(GenericListCellRenderer.SELECT_ALL_FLAG) != null) {
                            this.selectAllChecked = sel;
                            this.selectAllOffset = ((List)GenericListCellRenderer.this.parentList).getSelectedIndex();
                            int count = ((List)GenericListCellRenderer.this.parentList).getModel().getSize();
                            String selectionVal = "" + sel;
                            for (int x = 0; x < count; ++x) {
                                Object o = ((List)GenericListCellRenderer.this.parentList).getModel().getItemAt(x);
                                if (!(o instanceof Map)) continue;
                                ((Map)o).put(GenericListCellRenderer.this.selectedEntries[iter].getName(), selectionVal);
                            }
                        } else {
                            if (this.selectAllChecked) {
                                this.selectAllChecked = false;
                                Map selAll = (Map)((List)GenericListCellRenderer.this.parentList).getModel().getItemAt(this.selectAllOffset);
                                selAll.put(GenericListCellRenderer.this.selectedEntries[iter].getName(), "false");
                            }
                            h.put(GenericListCellRenderer.this.selectedEntries[iter].getName(), "" + sel);
                        }
                        return;
                    }
                }
            }
        }
    }
}

