/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.util;

import com.codename1.impl.CodenameOneImplementation;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil {
    private static CodenameOneImplementation impl;

    public static void setImplementation(CodenameOneImplementation i) {
        impl = i;
    }

    public static String replaceAll(String source, String pattern, String replace) {
        StringBuilder sb = new StringBuilder();
        int idx = 0;
        String workingSource = source;
        idx = workingSource.indexOf(pattern);
        if (idx == -1) {
            return source;
        }
        while (idx != -1) {
            sb.append(workingSource.substring(0, idx));
            sb.append(replace);
            workingSource = workingSource.substring(idx + pattern.length());
            idx = workingSource.indexOf(pattern);
        }
        sb.append(workingSource);
        return sb.toString();
    }

    public static String replaceFirst(String source, String pattern, String replace) {
        StringBuilder sb = new StringBuilder();
        int idx = 0;
        String workingSource = source;
        idx = workingSource.indexOf(pattern);
        if (idx == -1) {
            return source;
        }
        sb.append(workingSource.substring(0, idx));
        sb.append(replace);
        workingSource = workingSource.substring(idx + pattern.length());
        sb.append(workingSource);
        return sb.toString();
    }

    public static Vector tokenizeString(String source, char separator) {
        Vector<String> tokenized = new Vector<String>();
        int len = source.length();
        boolean lastSeparator = false;
        StringBuilder buf = new StringBuilder();
        for (int iter = 0; iter < len; ++iter) {
            char current = source.charAt(iter);
            if (current == separator) {
                if (lastSeparator) {
                    buf.append(separator);
                    lastSeparator = false;
                    continue;
                }
                lastSeparator = true;
                if (buf.length() <= 0) continue;
                tokenized.addElement(buf.toString());
                buf = new StringBuilder();
                continue;
            }
            lastSeparator = false;
            buf.append(current);
        }
        if (buf.length() > 0) {
            tokenized.addElement(buf.toString());
        }
        return tokenized;
    }

    public static Vector tokenizeString(String source, String separator) {
        if (separator.length() == 1) {
            return StringUtil.tokenizeString(source, separator.charAt(0));
        }
        Vector<String> tokenized = new Vector<String>();
        int len = source.length();
        StringBuilder buf = new StringBuilder();
        for (int iter = 0; iter < len; ++iter) {
            char current = source.charAt(iter);
            if (separator.indexOf(current) > -1) {
                if (buf.length() <= 0) continue;
                tokenized.addElement(buf.toString());
                buf = new StringBuilder();
                continue;
            }
            buf.append(current);
        }
        if (buf.length() > 0) {
            tokenized.addElement(buf.toString());
        }
        return tokenized;
    }

    public static List<String> tokenize(String source, char separator) {
        ArrayList<String> tokenized = new ArrayList<String>();
        if (impl == null) {
            int len = source.length();
            boolean lastSeparator = false;
            StringBuilder buf = new StringBuilder();
            for (int iter = 0; iter < len; ++iter) {
                char current = source.charAt(iter);
                if (current == separator) {
                    if (lastSeparator) {
                        lastSeparator = false;
                        continue;
                    }
                    lastSeparator = true;
                    if (buf.length() <= 0) continue;
                    tokenized.add(buf.toString());
                    buf = new StringBuilder();
                    continue;
                }
                lastSeparator = false;
                buf.append(current);
            }
            if (buf.length() > 0) {
                tokenized.add(buf.toString());
            }
        } else {
            impl.splitString(source, separator, tokenized);
        }
        return tokenized;
    }

    public static List<String> tokenize(String source, String separator) {
        if (separator.length() == 1) {
            return StringUtil.tokenize(source, separator.charAt(0));
        }
        ArrayList<String> tokenized = new ArrayList<String>();
        int len = source.length();
        StringBuilder buf = new StringBuilder();
        for (int iter = 0; iter < len; ++iter) {
            char current = source.charAt(iter);
            if (separator.indexOf(current) > -1) {
                if (buf.length() <= 0) continue;
                tokenized.add(buf.toString());
                buf = new StringBuilder();
                continue;
            }
            buf.append(current);
        }
        if (buf.length() > 0) {
            tokenized.add(buf.toString());
        }
        return tokenized;
    }

    public static String join(Iterable strings, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : strings) {
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append(obj);
        }
        return sb.toString();
    }

    public static String join(Object[] strings, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : strings) {
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append(obj);
        }
        return sb.toString();
    }
}

