/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.cloud;

import com.codename1.cloud.CloudObject;
import com.codename1.cloud.CloudStorage;
import com.codename1.cloud.CustomProperty;
import com.codename1.components.ReplaceableImage;
import com.codename1.io.CacheMap;
import com.codename1.io.ConnectionRequest;
import com.codename1.io.NetworkManager;
import com.codename1.ui.EncodedImage;
import com.codename1.ui.Image;
import com.codename1.ui.util.ImageIO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public class CloudImageProperty
implements CustomProperty {
    private static CacheMap cloudImageCache;
    private String idProperty;
    private EncodedImage placeholderImage;
    private Hashtable<Object, ReplaceableImage> inProgress = new Hashtable();

    public CloudImageProperty(String idProperty, EncodedImage placeholderImage) {
        this.idProperty = idProperty;
        this.placeholderImage = placeholderImage;
    }

    private CacheMap getCache() {
        if (cloudImageCache == null) {
            cloudImageCache = new CacheMap("CN1CIP$");
        }
        return cloudImageCache;
    }

    public Object propertyValue(CloudObject obj, String propertyName) {
        final String key = (String)obj.getObject(this.idProperty);
        if (key == null) {
            return this.placeholderImage;
        }
        Image image = (Image)this.getCache().get(key);
        if (image == null) {
            ReplaceableImage r = this.inProgress.get(key);
            if (r != null) {
                return r;
            }
            final ReplaceableImage rp = ReplaceableImage.create(this.placeholderImage);
            this.inProgress.put(key, rp);
            ConnectionRequest cr = new ConnectionRequest(){
                private EncodedImage e;

                protected void readResponse(InputStream input) throws IOException {
                    ImageIO io;
                    this.e = EncodedImage.create(input);
                    if ((this.e.getWidth() != CloudImageProperty.this.placeholderImage.getWidth() || this.e.getHeight() != CloudImageProperty.this.placeholderImage.getHeight()) && (io = ImageIO.getImageIO()) != null) {
                        ByteArrayOutputStream bo = new ByteArrayOutputStream();
                        io.save(new ByteArrayInputStream(this.e.getImageData()), (OutputStream)bo, "jpeg", CloudImageProperty.this.placeholderImage.getWidth(), CloudImageProperty.this.placeholderImage.getHeight(), 0.9f);
                        this.e = EncodedImage.create(bo.toByteArray());
                    }
                }

                protected void postResponse() {
                    rp.replace(this.e);
                    CloudImageProperty.this.getCache().put(key, this.e);
                    CloudImageProperty.this.inProgress.remove(key);
                }
            };
            cr.setPost(false);
            cr.setUrl(CloudStorage.getInstance().getUrlForCloudFileId(key));
            NetworkManager.getInstance().addToQueue(cr);
            return rp;
        }
        return image;
    }
}

