/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.ui.Button;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.Label;
import com.codename1.ui.TextArea;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.events.FocusListener;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.LayeredLayout;

public class FloatingHint
extends Container {
    private final TextArea tf;
    private final Button hintButton;
    private final Label hintLabel;

    public FloatingHint(final TextArea tf) {
        super(new LayeredLayout());
        this.tf = tf;
        Container content = new Container(new BorderLayout());
        this.add(content);
        this.hintButton = new Button(tf.getHint()){

            protected boolean shouldRenderComponentSelection() {
                return true;
            }
        };
        this.hintLabel = new Label(tf.getHint());
        tf.setHint("");
        this.hintButton.setFocusable(false);
        this.hintButton.setUIID("FloatingHint");
        this.hintLabel.setUIID("TextHint");
        tf.setLabelForComponent(this.hintButton);
        tf.setEditable(false);
        this.add(BorderLayout.north(new Label(" ")).add((Object)"Center", tf));
        this.add(BorderLayout.north(this.hintButton).add((Object)"Center", this.hintLabel));
        this.hintButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                tf.startEditingAsync();
            }
        });
        if (tf.getText() == null || tf.getText().length() == 0) {
            this.hintButton.setVisible(false);
        } else {
            this.hintLabel.setVisible(false);
        }
        FocusListener fl = new FocusListener(){

            public void focusGained(Component cmp) {
                FloatingHint.this.focusGainedImpl();
            }

            public void focusLost(Component cmp) {
                FloatingHint.this.focusLostImpl();
            }
        };
        tf.addFocusListener(fl);
    }

    private void focusGainedImpl() {
        if (this.isInitializedImpl()) {
            this.hintButton.setFocus(true);
            if (!this.hintButton.isVisible()) {
                this.hintButton.setVisible(true);
                if (this.getComponentForm().grabAnimationLock()) {
                    this.morphAndWait(this.hintLabel, this.hintButton, 150);
                    this.getComponentForm().releaseAnimationLock();
                }
                this.hintLabel.setVisible(false);
                this.tf.getComponentForm().revalidate();
                this.tf.setEditable(true);
                this.tf.startEditingAsync();
            } else {
                this.tf.setEditable(true);
                this.tf.startEditingAsync();
            }
        } else {
            boolean t = this.tf.getText() == null || this.tf.getText().length() == 0;
            this.hintButton.setVisible(t);
            this.hintLabel.setVisible(!t);
            this.revalidate();
        }
    }

    private boolean isInitializedImpl() {
        return this.isInitialized() && this.getComponentForm() == Display.getInstance().getCurrent();
    }

    private void focusLostImpl() {
        if (this.isInitializedImpl()) {
            this.hintButton.setFocus(false);
            if (this.tf.getText().length() == 0) {
                this.hintLabel.setVisible(true);
                if (this.getComponentForm().grabAnimationLock()) {
                    this.morphAndWait(this.hintButton, this.hintLabel, 150);
                    this.getComponentForm().releaseAnimationLock();
                }
                this.hintButton.setVisible(false);
                this.tf.getComponentForm().revalidate();
                this.revalidate();
                this.tf.setEditable(false);
            }
        } else {
            boolean t = this.tf.getText() == null || this.tf.getText().length() == 0;
            this.hintButton.setVisible(!t);
            this.hintLabel.setVisible(t);
            this.revalidate();
        }
    }

    protected void initComponent() {
        super.initComponent();
        if (this.tf.hasFocus()) {
            this.focusGainedImpl();
        }
    }
}

