/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.processing;

import com.codename1.io.JSONParser;
import com.codename1.processing.PrettyPrinter;
import com.codename1.processing.StructuredContent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

class MapContent
implements StructuredContent {
    private Object root;
    private StructuredContent parent;

    public MapContent(Map content) {
        this.root = content;
    }

    public MapContent(String content) throws IOException {
        this(new InputStreamReader((InputStream)new ByteArrayInputStream(content.getBytes("UTF-8")), "UTF-8"));
    }

    public MapContent(InputStream content) throws IOException {
        this(new JSONParser().parse(new InputStreamReader(content)));
    }

    public MapContent(Reader content) throws IOException {
        this(new JSONParser().parse(content));
    }

    MapContent(Object content, StructuredContent parent) {
        this.root = content;
        this.parent = parent;
    }

    public String toString() {
        if (this.root instanceof Map) {
            if (((Map)this.root).containsKey("ROOT")) {
                return PrettyPrinter.print((Map)((Map)this.root).get("ROOT"));
            }
            return PrettyPrinter.print((Map)this.root);
        }
        if (this.root instanceof List) {
            return PrettyPrinter.print((List)this.root);
        }
        return this.root.toString();
    }

    public int hashCode() {
        return this.root.hashCode();
    }

    public boolean equals(Object o) {
        return this.root.hashCode() == o.hashCode();
    }

    private List _asStructuredContentArray(List array) {
        if (array == null) {
            return null;
        }
        AbstractList children = array instanceof Vector ? new Vector() : new ArrayList();
        for (Object o : array) {
            if (o instanceof Map) {
                children.add(new MapContent((Map)o, this));
                continue;
            }
            if (!(o instanceof String)) continue;
            children.add(new MapContent(o, this));
        }
        return children;
    }

    public List getChildren(String name) {
        AbstractList array;
        boolean oldList;
        if (this.root instanceof String) {
            return new Vector();
        }
        Object node = this.root;
        boolean bl = oldList = node == null || node instanceof Vector;
        if (node instanceof List) {
            Object tmp = null;
            Iterator e = ((List)node).iterator();
            while (!(!e.hasNext() || (tmp = e.next()) instanceof Map && ((Map)tmp).containsKey(name))) {
                tmp = null;
            }
            if (tmp == null) {
                if (oldList) {
                    return new Vector();
                }
                return new ArrayList();
            }
            node = tmp;
        }
        if ((node = ((Map)node).get(name)) == null) {
            if (oldList) {
                return new Vector();
            }
            return new ArrayList();
        }
        if (node instanceof List) {
            return this._asStructuredContentArray((List)node);
        }
        if (node instanceof Map) {
            array = node instanceof Hashtable ? new Vector() : new ArrayList();
            array.add(new MapContent((Map)node, this));
            return array;
        }
        array = oldList ? new Vector() : new ArrayList();
        array.add(new MapContent(node.toString(), this));
        return array;
    }

    public StructuredContent getChild(int index) {
        if (this.root instanceof List) {
            return new MapContent(((List)this.root).get(index), this);
        }
        Map h = (Map)this.root;
        if (index < 0 || index >= h.size()) {
            return null;
        }
        Iterator elements = h.keySet().iterator();
        for (int i = 0; i < index; ++i) {
            elements.next();
        }
        Object node = elements.next();
        return new MapContent(node, this);
    }

    public List getDescendants(String name) {
        AbstractList decendants = this.root instanceof Vector || this.root instanceof Hashtable ? new Vector() : new ArrayList();
        if (this.root instanceof List) {
            this._findByName(decendants, (List)this.root, name);
        } else if (this.root instanceof Map) {
            this._findByName(decendants, (Map)this.root, name);
        }
        return decendants;
    }

    private void _findByName(List target, List source, String name) {
        for (int i = 0; i < source.size(); ++i) {
            Object o = source.get(i);
            if (o instanceof Map) {
                this._findByName(target, (Map)o, name);
                continue;
            }
            if (!(o instanceof List)) continue;
            this._findByName(target, (List)o, name);
        }
    }

    private void _findByName(List target, Map source, String name) {
        if (source.containsKey(name)) {
            Object o = source.get(name);
            if (o instanceof StructuredContent) {
                target.add((StructuredContent)o);
            } else {
                target.add(new MapContent(o, new MapContent(source)));
            }
        }
        for (Object o : source.values()) {
            if (o instanceof List) {
                this._findByName(target, (List)o, name);
                continue;
            }
            if (!(o instanceof Map)) continue;
            this._findByName(target, (Map)o, name);
        }
    }

    public String getAttribute(String name) {
        return null;
    }

    public Map getAttributes() {
        return null;
    }

    public StructuredContent getParent() {
        if (this.parent == null) {
            return null;
        }
        return this.parent;
    }

    public String getText() {
        if (this.root instanceof String) {
            return (String)this.root;
        }
        StructuredContent sc = this.getChild(0);
        if (sc == null) {
            return null;
        }
        if (sc.getNativeRoot() instanceof String) {
            return (String)sc.getNativeRoot();
        }
        return sc.toString();
    }

    public Object getNativeRoot() {
        return this.root;
    }
}

