/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.properties;

import com.codename1.properties.CollectionProperty;
import com.codename1.properties.PropertyBusinessObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListProperty<T, K>
extends CollectionProperty<T, K> {
    private ArrayList<T> value = new ArrayList();

    public ListProperty(String name, T ... values) {
        this(name, null, values);
    }

    public ListProperty(String name, Class<T> elementType, T ... values) {
        super(name, elementType);
        for (T t : values) {
            this.value.add(t);
        }
    }

    public ListProperty(String name) {
        super(name);
    }

    public T get(int offset) {
        return this.value.get(offset);
    }

    @Override
    public int size() {
        return this.value.size();
    }

    public K set(int offset, T v) {
        this.value.set(offset, v);
        this.firePropertyChanged();
        return (K)this.parent.parent;
    }

    @Override
    public K set(Collection<T> t) {
        this.value.clear();
        this.value.addAll(t);
        this.firePropertyChanged();
        return (K)this.parent.parent;
    }

    public K setList(Collection<T> t) {
        return this.set(t);
    }

    public K add(int offset, T v) {
        this.value.add(offset, v);
        this.firePropertyChanged();
        return (K)this.parent.parent;
    }

    @Override
    public K add(T v) {
        this.value.add(v);
        this.firePropertyChanged();
        return (K)this.parent.parent;
    }

    @Override
    public K addAll(Collection<? extends T> v) {
        if (this.value.addAll(v)) {
            this.firePropertyChanged();
        }
        return (K)this.parent.parent;
    }

    @Override
    public K remove(int offset) {
        this.value.remove(offset);
        this.firePropertyChanged();
        return (K)this.parent.parent;
    }

    @Override
    public K remove(T v) {
        if (this.value.remove(v)) {
            this.firePropertyChanged();
        }
        return (K)this.parent.parent;
    }

    @Override
    public K removeAll(Collection<? extends T> v) {
        if (this.value.removeAll(v)) {
            this.firePropertyChanged();
        }
        return (K)this.parent.parent;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ListProperty other = (ListProperty)obj;
        return other.value.equals(this.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public Iterator<T> iterator() {
        return this.value.iterator();
    }

    @Override
    public List<T> asList() {
        return new ArrayList<T>(this.value);
    }

    @Override
    public List<Object> asExplodedList() {
        ArrayList<Object> aa = new ArrayList<Object>();
        for (T t : this.value) {
            if (t instanceof PropertyBusinessObject) {
                aa.add(((PropertyBusinessObject)t).getPropertyIndex().toMapRepresentation());
                continue;
            }
            aa.add(t);
        }
        return aa;
    }

    @Override
    public void clear() {
        if (this.value.size() > 0) {
            this.value.clear();
            this.firePropertyChanged();
        }
    }

    @Override
    public boolean contains(T element) {
        return this.value.contains(element);
    }

    public int indexOf(T element) {
        return this.value.indexOf(element);
    }
}

