/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.animations;

import com.codename1.ui.Component;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.Transform;
import com.codename1.ui.animations.Motion;
import com.codename1.ui.animations.Transition;
import com.codename1.util.MathUtil;

public class FlipTransition
extends Transition {
    private static final int STATE_MOVE_AWAY = 1;
    private static final int STATE_FLIP = 2;
    private static final int STATE_MOVE_CLOSER = 3;
    private boolean perspectiveSupported = true;
    private Image sourceBuffer;
    private Image destBuffer;
    private float flipState = 0.0f;
    private float zState = 0.0f;
    private int transitionState = 1;
    private Motion motion;
    private boolean firstFinished = false;
    private boolean started = false;
    private int bgColor = -1;
    private float zNear;
    private float zFar;
    private int duration = 200;
    private Transform tmpTransform;
    private Transform perspectiveT;
    private Transform currTransform;

    public FlipTransition() {
    }

    public FlipTransition(int bgColor) {
        this.bgColor = bgColor;
    }

    public FlipTransition(int bgColor, int duration) {
        this.bgColor = bgColor;
        this.duration = duration;
    }

    public void initTransition() {
        this.flipState = 0.0f;
        this.transitionState = 1;
        this.zNear = 1600.0f;
        this.zFar = this.zNear + 3000.0f;
        Component source = this.getSource();
        Component destination = this.getDestination();
        int w = source.getWidth();
        int h = source.getHeight();
        if (w <= 0 || h <= 0) {
            return;
        }
        this.sourceBuffer = this.createMutableImage(source.getWidth(), source.getHeight());
        this.paint(this.sourceBuffer.getGraphics(), source, -source.getAbsoluteX(), -source.getAbsoluteY());
        this.destBuffer = this.createMutableImage(destination.getWidth(), destination.getHeight());
        this.paint(this.destBuffer.getGraphics(), destination, -destination.getAbsoluteX(), -destination.getAbsoluteY());
        if (source instanceof Form) {
            this.setBgColor(0);
        }
        this.motion = Motion.createLinearMotion(0, 100, this.duration);
        this.motion.start();
    }

    public boolean animate() {
        int val = this.motion.getValue();
        switch (this.transitionState) {
            case 1: {
                this.zState = (float)val / 100.0f;
                if (this.motion.isFinished() || !this.perspectiveSupported) {
                    this.transitionState = 2;
                    this.motion = Motion.createLinearMotion(0, 180, this.duration);
                    this.motion.start();
                }
                return true;
            }
            case 2: {
                double valInRadians = Math.PI / 180 * (double)val;
                double projectedPos = Math.cos(valInRadians);
                this.flipState = (float)(-projectedPos / 2.0 + 0.5);
                if (this.motion.isFinished()) {
                    this.transitionState = 3;
                    if (this.perspectiveSupported) {
                        this.motion = Motion.createLinearMotion(100, 0, this.duration);
                        this.motion.start();
                    } else {
                        return false;
                    }
                }
                return true;
            }
            case 3: {
                this.zState = (float)val / 100.0f;
                return !this.motion.isFinished();
            }
        }
        throw new RuntimeException("Invalid transition state");
    }

    private void makePerspectiveTransform(Transform t) {
        int x = this.getSource().getAbsoluteX();
        int y = this.getSource().getAbsoluteY();
        int w = this.getSource().getWidth();
        int h = this.getSource().getHeight();
        float displayH = Display.getInstance().getDisplayHeight();
        float displayW = Display.getInstance().getDisplayWidth();
        double fovy = 0.25;
        t.setPerspective((float)fovy, displayW / displayH, this.zNear, this.zFar);
    }

    public void paint(Graphics g) {
        if (this.destBuffer == null) {
            return;
        }
        int cx = g.getClipX();
        int cy = g.getClipY();
        int cw = g.getClipWidth();
        int ch = g.getClipHeight();
        int x = this.getSource().getAbsoluteX();
        int y = this.getSource().getAbsoluteY();
        int w = this.getSource().getWidth();
        int h = this.getSource().getHeight();
        g.setClip(x, y, w, h);
        if (this.getBgColor() >= 0) {
            int c = g.getColor();
            g.setColor(this.getBgColor());
            g.fillRect(x, y, w, h);
            g.setColor(c);
        } else {
            this.getSource().paintBackgrounds(g);
        }
        if (g.isPerspectiveTransformSupported()) {
            float displayH = Display.getInstance().getDisplayHeight();
            float displayW = Display.getInstance().getDisplayWidth();
            double midX = (double)x + (double)w / 2.0;
            if (this.perspectiveT == null) {
                this.perspectiveT = Transform.makeIdentity();
            }
            this.makePerspectiveTransform(this.perspectiveT);
            float[] bottomRight = this.perspectiveT.transformPoint(new float[]{displayW, displayH, this.zNear});
            if (this.currTransform == null) {
                this.currTransform = Transform.makeTranslation(0.0f, 0.0f, 0.0f);
            } else {
                this.currTransform.setIdentity();
            }
            float xfactor = -displayW / bottomRight[0];
            float yfactor = -displayH / bottomRight[1];
            this.currTransform.scale(xfactor, yfactor, 0.0f);
            this.currTransform.translate((float)(x + w / 2) / xfactor, (float)(y + h / 2) / yfactor, 0.0f);
            this.currTransform.concatenate(this.perspectiveT);
            float cameraZ = -this.zNear - (float)(w / 2) * this.zState;
            float cameraX = -x - w / 2;
            float cameraY = -y - h / 2;
            this.currTransform.translate(cameraX, cameraY, cameraZ);
            if (this.transitionState == 2) {
                this.currTransform.translate((float)midX, y, 0.0f);
            }
            Image img = null;
            if ((double)this.flipState < 0.5) {
                img = this.sourceBuffer;
                if (this.transitionState == 2) {
                    double sin = (double)this.flipState * 2.0;
                    double angle = MathUtil.asin(sin);
                    this.currTransform.rotate((float)angle, 0.0f, 1.0f, 0.0f);
                }
            } else {
                img = this.destBuffer;
                if (this.transitionState == 2) {
                    double sin = (1.0 - (double)this.flipState) * 2.0;
                    double angle = Math.PI - MathUtil.asin(sin);
                    this.currTransform.rotate((float)angle, 0.0f, 1.0f, 0.0f);
                }
            }
            if (this.transitionState == 2) {
                this.currTransform.translate(-((float)midX), -y, 0.0f);
                if (this.flipState >= 0.5f) {
                    this.currTransform.scale(-1.0f, 1.0f, 1.0f);
                    this.currTransform.translate(-2 * x - w, 0.0f, 0.0f);
                }
            }
            if (this.tmpTransform == null) {
                this.tmpTransform = Transform.makeIdentity();
            }
            g.getTransform(this.tmpTransform);
            g.setTransform(this.currTransform);
            g.drawImage(img, x, y, w, h);
            g.setTransform(this.tmpTransform);
        } else {
            this.perspectiveSupported = false;
            if ((double)this.flipState < 0.5) {
                int frontX = x + (int)(this.flipState * (float)w);
                int frontWidth = (int)((double)w * (1.0 - (double)this.flipState * 2.0));
                g.drawImage(this.sourceBuffer, frontX, y, frontWidth, h);
            } else {
                double backState = 1.0 - (double)this.flipState;
                int backX = x + (int)(backState * (double)w);
                int backWidth = (int)((double)w * (1.0 - backState * 2.0));
                g.drawImage(this.destBuffer, backX, y, backWidth, h);
            }
        }
        g.setClip(cx, cy, cw, ch);
    }

    private Image createMutableImage(int w, int h) {
        Display d = Display.getInstance();
        return Image.createImage(Math.min(d.getDisplayWidth(), w), Math.min(d.getDisplayHeight(), h));
    }

    private void paint(Graphics g, Component cmp, int x, int y) {
        this.paint(g, cmp, x, y, false);
    }

    private void paint(Graphics g, Component cmp, int x, int y, boolean background) {
        int cx = g.getClipX();
        int cy = g.getClipY();
        int cw = g.getClipWidth();
        int ch = g.getClipHeight();
        g.translate(x, y);
        cmp.paintComponent(g, background);
        g.translate(-x, -y);
        g.setClip(cx, cy, cw, ch);
    }

    public void cleanup() {
        this.sourceBuffer = null;
        this.destBuffer = null;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(int bgColor) {
        this.bgColor = bgColor;
    }

    public Transition copy(boolean reverse) {
        return new FlipTransition(this.bgColor, this.duration);
    }
}

