/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.charts.models;

import com.codename1.charts.models.XYSeries;
import java.util.ArrayList;
import java.util.List;

public class MultipleCategorySeries {
    private final String mTitle;
    private final List<String> mCategories = new ArrayList<String>();
    private final List<String[]> mTitles = new ArrayList<String[]>();
    private final List<double[]> mValues = new ArrayList<double[]>();

    public MultipleCategorySeries(String title) {
        this.mTitle = title;
    }

    public void add(String[] titles, double[] values) {
        this.add(this.mCategories.size() + "", titles, values);
    }

    public void add(String category, String[] titles, double[] values) {
        this.mCategories.add(category);
        this.mTitles.add(titles);
        this.mValues.add(values);
    }

    public void remove(int index) {
        this.mCategories.remove(index);
        this.mTitles.remove(index);
        this.mValues.remove(index);
    }

    public void clear() {
        this.mCategories.clear();
        this.mTitles.clear();
        this.mValues.clear();
    }

    public double[] getValues(int index) {
        return this.mValues.get(index);
    }

    public String getCategory(int index) {
        return this.mCategories.get(index);
    }

    public int getCategoriesCount() {
        return this.mCategories.size();
    }

    public int getItemCount(int index) {
        return this.mValues.get(index).length;
    }

    public String[] getTitles(int index) {
        return this.mTitles.get(index);
    }

    public XYSeries toXYSeries() {
        XYSeries xySeries = new XYSeries(this.mTitle);
        return xySeries;
    }
}

