/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.charts.models;

import com.codename1.charts.models.XYSeries;
import java.util.ArrayList;
import java.util.List;

public class XYValueSeries
extends XYSeries {
    private final List<Double> mValue = new ArrayList<Double>();
    private double mMinValue = -1.7976931348623157E308;
    private double mMaxValue = -1.7976931348623157E308;

    public XYValueSeries(String title) {
        super(title);
    }

    public synchronized void add(double x, double y, double value) {
        super.add(x, y);
        this.mValue.add(value);
        this.updateRange(value);
    }

    private void initRange() {
        this.mMinValue = -1.7976931348623157E308;
        this.mMaxValue = -1.7976931348623157E308;
        int length = this.getItemCount();
        for (int k = 0; k < length; ++k) {
            this.updateRange(this.getValue(k));
        }
    }

    private void updateRange(double value) {
        this.mMinValue = this.mMinValue == -1.7976931348623157E308 ? value : Math.min(this.mMinValue, value);
        this.mMaxValue = this.mMaxValue == -1.7976931348623157E308 ? value : Math.max(this.mMaxValue, value);
    }

    public synchronized void add(double x, double y) {
        this.add(x, y, 0.0);
    }

    public synchronized void remove(int index) {
        super.remove(index);
        double removedValue = this.mValue.remove(index);
        if (removedValue == this.mMinValue || removedValue == this.mMaxValue) {
            this.initRange();
        }
    }

    public synchronized void clear() {
        super.clear();
        this.mValue.clear();
        this.initRange();
    }

    public synchronized double getValue(int index) {
        return this.mValue.get(index);
    }

    public double getMinValue() {
        return this.mMinValue;
    }

    public double getMaxValue() {
        return this.mMaxValue;
    }
}

