/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.charts.transitions;

import com.codename1.charts.ChartComponent;
import com.codename1.charts.models.XYSeries;
import com.codename1.charts.transitions.SeriesTransition;

public class XYSeriesTransition
extends SeriesTransition {
    private final XYSeries series;
    private XYSeries cachedSeries;
    private XYSeries startVals;
    private XYSeries endVals;

    public XYSeriesTransition(ChartComponent chart, XYSeries series) {
        super(chart);
        this.series = series;
    }

    public void initTransition() {
        super.initTransition();
        this.startVals = new XYSeries("Start");
        this.copyValues(this.series, this.startVals);
        this.endVals = new XYSeries("End");
        this.copyValues(this.cachedSeries, this.endVals);
    }

    private void copyValues(XYSeries source, XYSeries target) {
        int len = source.getItemCount();
        for (int i = 0; i < len; ++i) {
            int index = target.getIndexForKey(source.getX(i));
            if (index > -1) {
                target.remove(index);
            }
            target.add(source.getX(i), source.getY(i));
        }
    }

    protected void cleanup() {
        super.cleanup();
        this.cachedSeries.clear();
    }

    protected void update(int progress) {
        double dProgress = progress;
        int len = this.endVals.getItemCount();
        for (int i = 0; i < len; ++i) {
            double x = this.endVals.getX(i);
            double y = this.endVals.getY(i);
            int startIndex = this.startVals.getIndexForKey(x);
            double startVal = startIndex == -1 ? 0.0 : this.startVals.getY(startIndex);
            double endVal = y;
            double tweenVal = startVal + (endVal - startVal) * dProgress / 100.0;
            int seriesIndex = this.series.getIndexForKey(x);
            if (seriesIndex > -1) {
                this.series.remove(seriesIndex);
            }
            this.series.add(x, tweenVal);
        }
    }

    public XYSeries getBuffer() {
        if (this.cachedSeries == null) {
            this.cachedSeries = new XYSeries(this.series.getTitle(), this.series.getScaleNumber());
        }
        return this.cachedSeries;
    }

    void setBuffer(XYSeries buffer) {
        this.cachedSeries = buffer;
    }

    public XYSeries getSeries() {
        return this.series;
    }
}

