/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.charts.views;

import com.codename1.charts.compat.Canvas;
import com.codename1.charts.compat.Paint;
import com.codename1.charts.models.XYMultipleSeriesDataset;
import com.codename1.charts.models.XYSeries;
import com.codename1.charts.renderers.SimpleSeriesRenderer;
import com.codename1.charts.renderers.XYMultipleSeriesRenderer;
import com.codename1.charts.renderers.XYSeriesRenderer;
import com.codename1.charts.views.BarChart;
import com.codename1.charts.views.BubbleChart;
import com.codename1.charts.views.ClickableArea;
import com.codename1.charts.views.CubicLineChart;
import com.codename1.charts.views.LineChart;
import com.codename1.charts.views.RangeBarChart;
import com.codename1.charts.views.RangeStackedBarChart;
import com.codename1.charts.views.ScatterChart;
import com.codename1.charts.views.TimeChart;
import com.codename1.charts.views.XYChart;
import com.codename1.io.Log;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedXYChart
extends XYChart {
    private final XYCombinedChartDef[] chartDefinitions;
    private final XYChart[] mCharts;
    private final Class<?>[] xyChartTypes = new Class[]{TimeChart.class, LineChart.class, CubicLineChart.class, BarChart.class, BubbleChart.class, ScatterChart.class, RangeBarChart.class, RangeStackedBarChart.class};

    public CombinedXYChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer, XYCombinedChartDef[] chartDefinitions) {
        super(dataset, renderer);
        this.chartDefinitions = chartDefinitions;
        int length = chartDefinitions.length;
        this.mCharts = new XYChart[length];
        for (int i = 0; i < length; ++i) {
            try {
                this.mCharts[i] = this.getXYChart(chartDefinitions[i].getType());
            }
            catch (Exception e) {
                Log.e(e);
            }
            if (this.mCharts[i] == null) {
                throw new IllegalArgumentException("Unknown chart type " + chartDefinitions[i].getType());
            }
            XYMultipleSeriesDataset newDataset = new XYMultipleSeriesDataset();
            XYMultipleSeriesRenderer newRenderer = new XYMultipleSeriesRenderer();
            for (int seriesIndex : chartDefinitions[i].getSeriesIndex()) {
                newDataset.addSeries(dataset.getSeriesAt(seriesIndex));
                newRenderer.addSeriesRenderer(renderer.getSeriesRendererAt(seriesIndex));
            }
            newRenderer.setBarSpacing(renderer.getBarSpacing());
            newRenderer.setPointSize(renderer.getPointSize());
            this.mCharts[i].setDatasetRenderer(newDataset, newRenderer);
        }
    }

    private XYChart getXYChart(String type) throws IllegalAccessException, InstantiationException {
        XYChart chart = null;
        int length = this.xyChartTypes.length;
        for (int i = 0; i < length && chart == null; ++i) {
            XYChart newChart = (XYChart)this.xyChartTypes[i].newInstance();
            if (!type.equals(newChart.getChartType())) continue;
            chart = newChart;
        }
        return chart;
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, List<Float> points, XYSeriesRenderer seriesRenderer, float yAxisValue, int seriesIndex, int startIndex) {
        XYChart chart = this.getXYChart(seriesIndex);
        chart.setScreenR(this.getScreenR());
        chart.setCalcRange(this.getCalcRange(this.mDataset.getSeriesAt(seriesIndex).getScaleNumber()), 0);
        chart.drawSeries(canvas, paint, points, seriesRenderer, yAxisValue, this.getChartSeriesIndex(seriesIndex), startIndex);
    }

    @Override
    protected ClickableArea[] clickableAreasForPoints(List<Float> points, List<Double> values, float yAxisValue, int seriesIndex, int startIndex) {
        XYChart chart = this.getXYChart(seriesIndex);
        return chart.clickableAreasForPoints(points, values, yAxisValue, this.getChartSeriesIndex(seriesIndex), startIndex);
    }

    @Override
    protected void drawSeries(XYSeries series, Canvas canvas, Paint paint, List<Float> pointsList, XYSeriesRenderer seriesRenderer, float yAxisValue, int seriesIndex, XYMultipleSeriesRenderer.Orientation or, int startIndex) {
        XYChart chart = this.getXYChart(seriesIndex);
        chart.setScreenR(this.getScreenR());
        chart.setCalcRange(this.getCalcRange(this.mDataset.getSeriesAt(seriesIndex).getScaleNumber()), 0);
        chart.drawSeries(series, canvas, paint, pointsList, seriesRenderer, yAxisValue, this.getChartSeriesIndex(seriesIndex), or, startIndex);
    }

    @Override
    public int getLegendShapeWidth(int seriesIndex) {
        XYChart chart = this.getXYChart(seriesIndex);
        return chart.getLegendShapeWidth(this.getChartSeriesIndex(seriesIndex));
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer renderer, float x, float y, int seriesIndex, Paint paint) {
        XYChart chart = this.getXYChart(seriesIndex);
        chart.drawLegendShape(canvas, renderer, x, y, this.getChartSeriesIndex(seriesIndex), paint);
    }

    @Override
    public String getChartType() {
        return "Combined";
    }

    private XYChart getXYChart(int seriesIndex) {
        int clen = this.chartDefinitions.length;
        for (int i = 0; i < clen; ++i) {
            if (!this.chartDefinitions[i].containsSeries(seriesIndex)) continue;
            return this.mCharts[i];
        }
        throw new IllegalArgumentException("Unknown series with index " + seriesIndex);
    }

    private int getChartSeriesIndex(int seriesIndex) {
        int clen = this.chartDefinitions.length;
        for (int i = 0; i < clen; ++i) {
            if (!this.chartDefinitions[i].containsSeries(seriesIndex)) continue;
            return this.chartDefinitions[i].getChartSeriesIndex(seriesIndex);
        }
        throw new IllegalArgumentException("Unknown series with index " + seriesIndex);
    }

    public static class XYCombinedChartDef {
        private final String type;
        private final int[] seriesIndex;

        public XYCombinedChartDef(String type, int ... seriesIndex) {
            this.type = type;
            this.seriesIndex = seriesIndex;
        }

        public boolean containsSeries(int seriesIndex) {
            return this.getChartSeriesIndex(seriesIndex) >= 0;
        }

        public int getChartSeriesIndex(int seriesIndex) {
            int slen = this.getSeriesIndex().length;
            for (int i = 0; i < slen; ++i) {
                if (this.seriesIndex[i] != seriesIndex) continue;
                return i;
            }
            return -1;
        }

        public String getType() {
            return this.type;
        }

        public int[] getSeriesIndex() {
            return this.seriesIndex;
        }
    }
}

