/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.charts.views;

import com.codename1.charts.compat.Canvas;
import com.codename1.charts.compat.Paint;
import com.codename1.charts.models.CategorySeries;
import com.codename1.charts.renderers.DialRenderer;
import com.codename1.charts.views.RoundChart;

public class DialChart
extends RoundChart {
    private static final int NEEDLE_RADIUS = 10;
    private final DialRenderer mRenderer;

    public DialChart(CategorySeries dataset, DialRenderer renderer) {
        super(dataset, renderer);
        this.mRenderer = renderer;
    }

    public void draw(Canvas canvas, int x, int y, int width, int height, Paint paint) {
        paint.setAntiAlias(this.mRenderer.isAntialiasing());
        paint.setStyle(Paint.Style.FILL);
        paint.setTextSize(this.mRenderer.getLabelsTextSize());
        int legendSize = this.getLegendSize(this.mRenderer, height / 5, 0.0f);
        int left = x;
        int top = y;
        int right = x + width;
        int sLength = this.mDataset.getItemCount();
        String[] titles = new String[sLength];
        for (int i = 0; i < sLength; ++i) {
            titles[i] = this.mDataset.getCategory(i);
        }
        if (this.mRenderer.isFitLegend()) {
            legendSize = this.drawLegend(canvas, this.mRenderer, titles, left, right, y, width, height, legendSize, paint, true);
        }
        int bottom = y + height - legendSize;
        this.drawBackground(this.mRenderer, canvas, x, y, width, height, paint, false, 0);
        int mRadius = Math.min(Math.abs(right - left), Math.abs(bottom - top));
        int radius = (int)((double)mRadius * 0.35 * (double)this.mRenderer.getScale());
        if (this.autoCalculateCenter || this.mCenterX == Integer.MAX_VALUE) {
            this.mCenterX = (left + right) / 2;
        }
        if (this.autoCalculateCenter || this.mCenterY == Integer.MAX_VALUE) {
            this.mCenterY = (bottom + top) / 2;
        }
        float shortRadius = (float)radius * 0.9f;
        float longRadius = (float)radius * 1.1f;
        double min = this.mRenderer.getMinValue();
        double max = this.mRenderer.getMaxValue();
        double angleMin = this.mRenderer.getAngleMin();
        double angleMax = this.mRenderer.getAngleMax();
        if (!this.mRenderer.isMinValueSet() || !this.mRenderer.isMaxValueSet()) {
            int count = this.mRenderer.getSeriesRendererCount();
            for (int i = 0; i < count; ++i) {
                double value = this.mDataset.getValue(i);
                if (!this.mRenderer.isMinValueSet()) {
                    double d = min = min == -1.7976931348623157E308 ? value : Math.min(min, value);
                }
                if (this.mRenderer.isMaxValueSet()) continue;
                max = max == -1.7976931348623157E308 ? value : Math.max(max, value);
            }
        }
        if (min == max) {
            min *= 0.5;
            max *= 1.5;
        }
        paint.setColor(this.mRenderer.getLabelsColor());
        double minorTicks = this.mRenderer.getMinorTicksSpacing();
        double majorTicks = this.mRenderer.getMajorTicksSpacing();
        if (minorTicks == -1.7976931348623157E308) {
            minorTicks = (max - min) / 30.0;
        }
        if (majorTicks == -1.7976931348623157E308) {
            majorTicks = (max - min) / 10.0;
        }
        this.drawTicks(canvas, min, max, angleMin, angleMax, this.mCenterX, this.mCenterY, longRadius, radius, minorTicks, paint, false);
        this.drawTicks(canvas, min, max, angleMin, angleMax, this.mCenterX, this.mCenterY, longRadius, shortRadius, majorTicks, paint, true);
        int count = this.mRenderer.getSeriesRendererCount();
        for (int i = 0; i < count; ++i) {
            double angle = this.getAngleForValue(this.mDataset.getValue(i), angleMin, angleMax, min, max);
            paint.setColor(this.mRenderer.getSeriesRendererAt(i).getColor());
            boolean type = this.mRenderer.getVisualTypeForIndex(i) == DialRenderer.Type.ARROW;
            this.drawNeedle(canvas, angle, this.mCenterX, this.mCenterY, shortRadius, type, paint);
        }
        this.drawLegend(canvas, this.mRenderer, titles, left, right, y, width, height, legendSize, paint, false);
        this.drawTitle(canvas, x, y, width, paint);
    }

    private double getAngleForValue(double value, double minAngle, double maxAngle, double min, double max) {
        double angleDiff = maxAngle - minAngle;
        double diff = max - min;
        return Math.toRadians(minAngle + (value - min) * angleDiff / diff);
    }

    private void drawTicks(Canvas canvas, double min, double max, double minAngle, double maxAngle, int centerX, int centerY, double longRadius, double shortRadius, double ticks, Paint paint, boolean labels) {
        for (double i = min; i <= max; i += ticks) {
            double angle = this.getAngleForValue(i, minAngle, maxAngle, min, max);
            double sinValue = Math.sin(angle);
            double cosValue = Math.cos(angle);
            int x1 = Math.round((float)centerX + (float)(shortRadius * sinValue));
            int y1 = Math.round((float)centerY + (float)(shortRadius * cosValue));
            int x2 = Math.round((float)centerX + (float)(longRadius * sinValue));
            int y2 = Math.round((float)centerY + (float)(longRadius * cosValue));
            canvas.drawLine(x1, y1, x2, y2, paint);
            if (!labels) continue;
            paint.setTextAlign(1);
            if (x1 <= x2) {
                paint.setTextAlign(3);
            }
            String text = i + "";
            if (Math.round(i) == (long)i) {
                text = (long)i + "";
            }
            canvas.drawText(text, x1, y1, paint);
        }
    }

    private void drawNeedle(Canvas canvas, double angle, int centerX, int centerY, double radius, boolean arrow, Paint paint) {
        float[] points;
        double diff = Math.toRadians(90.0);
        int needleSinValue = (int)(10.0 * Math.sin(angle - diff));
        int needleCosValue = (int)(10.0 * Math.cos(angle - diff));
        int needleX = (int)(radius * Math.sin(angle));
        int needleY = (int)(radius * Math.cos(angle));
        int needleCenterX = centerX + needleX;
        int needleCenterY = centerY + needleY;
        if (arrow) {
            int arrowBaseX = centerX + (int)(radius * 0.85 * Math.sin(angle));
            int arrowBaseY = centerY + (int)(radius * 0.85 * Math.cos(angle));
            points = new float[]{arrowBaseX - needleSinValue, arrowBaseY - needleCosValue, needleCenterX, needleCenterY, arrowBaseX + needleSinValue, arrowBaseY + needleCosValue};
            float width = paint.getStrokeWidth();
            paint.setStrokeWidth(5.0f);
            canvas.drawLine(centerX, centerY, needleCenterX, needleCenterY, paint);
            paint.setStrokeWidth(width);
        } else {
            points = new float[]{centerX - needleSinValue, centerY - needleCosValue, needleCenterX, needleCenterY, centerX + needleSinValue, centerY + needleCosValue};
        }
        this.drawPath(canvas, points, paint, true);
    }
}

