/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.charts.views;

import com.codename1.ui.geom.GeneralPath;
import com.codename1.ui.geom.Shape;

public class PieSegment {
    private final float mStartAngle;
    private final float mEndAngle;
    private final int mDataIndex;
    private final float mValue;

    public PieSegment(int dataIndex, float value, float startAngle, float angle) {
        this.mStartAngle = startAngle;
        this.mEndAngle = angle + startAngle;
        this.mDataIndex = dataIndex;
        this.mValue = value;
    }

    public boolean isInSegment(double angle) {
        double stopAngle;
        if (angle >= (double)this.mStartAngle && angle <= (double)this.mEndAngle) {
            return true;
        }
        double cAngle = angle % 360.0;
        double startAngle = this.mStartAngle;
        for (stopAngle = (double)this.mEndAngle; stopAngle > 360.0; stopAngle -= 360.0) {
            startAngle -= 360.0;
        }
        return cAngle >= startAngle && cAngle <= stopAngle;
    }

    protected float getStartAngle() {
        return this.mStartAngle;
    }

    protected float getEndAngle() {
        return this.mEndAngle;
    }

    protected int getDataIndex() {
        return this.mDataIndex;
    }

    protected float getValue() {
        return this.mValue;
    }

    public String toString() {
        return "mDataIndex=" + this.mDataIndex + ",mValue=" + this.mValue + ",mStartAngle=" + this.mStartAngle + ",mEndAngle=" + this.mEndAngle;
    }

    public Shape getShape(float cX, float cY, float radius) {
        GeneralPath out = new GeneralPath();
        out.moveTo(cX, cY);
        out.lineTo((double)cX + (double)radius * Math.cos(Math.toRadians(this.mStartAngle)), (double)cY + (double)radius * Math.sin(Math.toRadians(this.mStartAngle)));
        out.arcTo((double)cX, (double)cY, (double)cX + (double)radius * Math.cos(Math.toRadians(this.mEndAngle)), (double)cY + (double)radius * Math.sin(Math.toRadians(this.mEndAngle)));
        out.closePath();
        return out;
    }
}

