/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.charts.views;

import com.codename1.charts.compat.Canvas;
import com.codename1.charts.compat.Paint;
import com.codename1.charts.models.AreaSeries;
import com.codename1.charts.renderers.DefaultRenderer;
import com.codename1.charts.renderers.SimpleSeriesRenderer;
import com.codename1.charts.util.ColorUtil;
import com.codename1.charts.views.RoundChart;
import com.codename1.ui.geom.Rectangle2D;
import java.util.ArrayList;

public class RadarChart
extends RoundChart {
    private final AreaSeries mDataset;
    private int mStep;

    public RadarChart(AreaSeries dataset, DefaultRenderer renderer) {
        super(null, renderer);
        this.mDataset = dataset;
    }

    public void draw(Canvas canvas, int x, int y, int width, int height, Paint paint) {
        paint.setAntiAlias(this.mRenderer.isAntialiasing());
        paint.setStyle(Paint.Style.FILL);
        paint.setTextSize(this.mRenderer.getLabelsTextSize());
        int legendSize = this.getLegendSize(this.mRenderer, height / 5, 0.0f);
        int left = x;
        int top = y;
        int right = x + width;
        int cLength = this.mDataset.getCategoriesCount();
        if (cLength < 3) {
            return;
        }
        String[] categories = this.mDataset.getCategories();
        int bottom = y + height - legendSize;
        this.drawBackground(this.mRenderer, canvas, x, y, width, height, paint, false, 0);
        this.mStep = 7;
        int mRadius = Math.min(Math.abs(right - left), Math.abs(bottom - top));
        double rCoef = 0.35 * (double)this.mRenderer.getScale();
        double decCoef = 0.2;
        int radius = (int)((double)mRadius * rCoef);
        if (this.autoCalculateCenter || this.mCenterX == Integer.MAX_VALUE) {
            this.mCenterX = (left + right) / 2;
        }
        if (this.autoCalculateCenter || this.mCenterY == Integer.MAX_VALUE) {
            this.mCenterY = (bottom + top) / 2;
        }
        float shortRadius = radius;
        float longRadius = (float)radius * 1.1f;
        ArrayList<Rectangle2D> prevLabelsBounds = new ArrayList<Rectangle2D>();
        float currentAngle = this.mRenderer.getStartAngle();
        float angle = 360.0f / (float)cLength;
        float centerX = (left + right) / 2;
        float centerY = (top + bottom) / 2;
        for (int i = 0; i < cLength; ++i) {
            paint.setColor(ColorUtil.GRAY);
            float thisRad = (float)Math.toRadians(90.0f - currentAngle);
            float nextRad = (float)Math.toRadians(90.0f - (currentAngle + angle));
            for (double level = 0.0; level <= 1.0; level += decCoef) {
                float levelFactor = (float)level;
                float thisX = (float)((double)centerX - Math.sin(thisRad) * (double)radius * (double)levelFactor);
                float thisY = (float)((double)centerY - Math.cos(thisRad) * (double)radius * (double)levelFactor);
                float nextX = (float)((double)centerX - Math.sin(nextRad) * (double)radius * (double)levelFactor);
                float nextY = (float)((double)centerY - Math.cos(nextRad) * (double)radius * (double)levelFactor);
                canvas.drawLine(thisX, thisY, nextX, nextY, paint);
            }
            canvas.drawLine(centerX, centerY, centerX - (float)Math.sin(thisRad) * (float)radius, centerY - (float)Math.cos(thisRad) * (float)radius, paint);
            paint.setColor(ColorUtil.GRAY);
            if (cLength % 2 == 0) {
                this.drawLabel(canvas, categories[i], this.mRenderer, prevLabelsBounds, this.mCenterX, this.mCenterY, shortRadius, longRadius, currentAngle - angle / 2.0f, angle, left, right, this.mRenderer.getLabelsColor(), paint, true, false);
            } else {
                this.drawLabel(canvas, categories[i], this.mRenderer, prevLabelsBounds, this.mCenterX, this.mCenterY, shortRadius, longRadius, currentAngle, angle, left, right, this.mRenderer.getLabelsColor(), paint, true, false);
            }
            currentAngle += angle;
        }
        int sLength = this.mDataset.getSeriesCount();
        int alignment = cLength / 2;
        for (int i = 0; i < sLength; ++i) {
            currentAngle = this.mRenderer.getStartAngle();
            paint.setColor(this.mRenderer.getSeriesRendererAt(i).getColor());
            for (int j = 0; j < cLength; ++j) {
                float thisValue = (float)this.mDataset.getValue(i, categories[(j + alignment) % cLength]);
                float nextValue = (float)this.mDataset.getValue(i, categories[(j + alignment + 1) % cLength]);
                float thisRad = (float)Math.toRadians(90.0f - currentAngle);
                float nextRad = (float)Math.toRadians(90.0f - (currentAngle + angle));
                float thisX = (float)((double)centerX - Math.sin(thisRad) * (double)radius * (double)thisValue);
                float thisY = (float)((double)centerY - Math.cos(thisRad) * (double)radius * (double)thisValue);
                float nextX = (float)((double)centerX - Math.sin(nextRad) * (double)radius * (double)nextValue);
                float nextY = (float)((double)centerY - Math.cos(nextRad) * (double)radius * (double)nextValue);
                canvas.drawLine(thisX, thisY, nextX, nextY, paint);
                currentAngle += angle;
            }
        }
        if (this.mRenderer.getBackgroundColor() != 0) {
            paint.setColor(this.mRenderer.getBackgroundColor());
        } else {
            paint.setColor(ColorUtil.WHITE);
        }
        prevLabelsBounds.clear();
        this.drawLegend(canvas, this.mRenderer, this.mDataset.getSeries(), left, right, y, width, height, legendSize, paint, false);
        this.drawTitle(canvas, x, y, width, paint);
    }

    public int getLegendShapeWidth(int seriesIndex) {
        return 10;
    }

    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer renderer, float x, float y, int seriesIndex, Paint paint) {
        canvas.drawCircle(x + 10.0f - (float)this.mStep, y, this.mStep, paint);
        --this.mStep;
    }
}

